begin

  res                       = True              ; Plot mods desired.
  res@gsnMaximize           = True              ; Maximize plot
  res@gsnAddCyclic          = False             ; don't add a longitude cyclic point
  res@cnFillOn              = True              ; color plot desired
  res@cnFillOpacityF        = 0.6               ; apply a little opacity so we can see mesh lines better
  res@cnFillMode            = "CellFill"
  res@cnFillPalette         = "BlAqGrWh2YeOrReVi22"
;  res@cnFillPalette         = "BlueWhiteOrangeRed"
  res@cnLinesOn             = False             ; turn off contour lines
  res@cnLineLabelsOn        = False             ; turn off contour labels
  res@tiMainFontHeightF     = 0.017
  res@pmTitleZone           = 4                 ; move title down
  res@mpFillOn              = False             ; turn off map fill
  res@pmTickMarkDisplayMode = "Always"          ; nicer map tickmark labels
  res@mpDataBaseVersion     = "LowRes"       ; better map outlines
  res@mpOutlineBoundarySets = "Geophysical"
  res@mpOutlineOn           = True
  res@mpNationalLineThicknessF    = 2.0      ; for better looking images
  res@mpGeophysicalLineThicknessF = 2.0
  res@mpCountyLineThicknessF      = 2.0
  res@mpProvincialLineThicknessF  = 2.0
  res@gsnRightString        = ""
  res@gsnLeftString         = ""
  res@lbLabelBarOn          = True             ; Will turn on in panel
  res@cnLevelSelectionMode = "ManualLevels"
  res@cnMinLevelValF = -0.5
  res@cnMaxLevelValF = 0.5
  res@cnLevelSpacingF = 0.05

;  if(True) then
;    wks = gsn_open_wks("x11","blah") 
;  else
;    wks = gsn_open_wks("png","albedo_bsa_vis_2011195.png")
   wks = gsn_open_wks("png","model_DA_IMS_SCF_96diff_20200115.png") 
;  end if

  infile = addfile("/scratch2/NCEPDEV/land/Michael.Barlage/forcing/C96/vector/ufs-land_C96_corners.nc","r")
  
  lat  = infile->latitude
  lon  = infile->longitude
  latc = infile->latitude_corners
  lonc = infile->longitude_corners

  res@sfXArray      := lon               ; necessary for plotting MPAS
  res@sfYArray      := lat
  res@sfYCellBounds := latc     ; necessary for CellFill 
  res@sfXCellBounds := lonc

  model_filename = "/scratch2/NCEPDEV/land/Youlong.Xia/landDA/cycle_land/DA_era5/mem000/restarts/vector/ufs_land_restart_back.2020-01-15_18-00-00.nc"
  modis_filename = "/scratch2/NCEPDEV/land/data/DA/snow_ice_cover/IMS/CalSnowCover/4km/C96/IMSscf.C96.4m.20200115.nc"
  infile1 = addfile(model_filename,"r")
  infile2 = addfile(modis_filename ,"r") 
  invar1 = infile1->snow_cover_fraction(0,:)
  invar2 = 0.01*infile2->snow_cover_fraction(0,:)
  invar = invar1-invar2
  range_only = invar
  range_only = mask(invar,(invar.le.1.0),True)
  plot = gsn_csm_contour_map(wks,range_only,res)  

end
