import netCDF4
import matplotlib.pyplot as plt
import cartopy.feature as cfeature
import numpy as np
import pandas as pd
import cartopy.crs as ccrs
import os
from datetime import datetime
from datetime import timedelta
from dateutil.relativedelta import relativedelta

def ReadNETCDF(FilePath, VariName):
    f = netCDF4.Dataset(FilePath)
    MyArray = f.variables[VariName][:].ravel()
    return MyArray

def Computediff(VariName):
    print(VariName)
    DAFilePath1="/scratch1/NCEPDEV/stmp4/Youlong.Xia/landDA/cycle_land/C768/DA_GHCN_2015to2020/mem000/restarts/vector"
    DAFilePath2="/scratch2/NCEPDEV/stmp3/Youlong.Xia/landDA/cycle_land/C768/DA_imsGHCN_2015to2020/mem000/restarts/vector"
    OpenloopFilePath="/scratch1/NCEPDEV/stmp4/Youlong.Xia/landDA/cycle_land/C768/openloop_ghcnHOFX_2015to2020/mem000/restarts/vector"
    cmcFilePath="/scratch2/NCEPDEV/land/data/evaluation/CMC/FV3ufsLand/C768"

    RestartDate = "2019-10-01_00-00-00"
    DeltaTime = 1  # day
    SimulationDuration = 366  # days

    RestartDate = datetime.strptime(RestartDate, '%Y-%m-%d_%H-%M-%S')
#we want to create 3 dataframe: 1) Truth_stdDF: the rows are locations and columns are truth value at each time step and the last column will be the standard deviation of truth, 2) diff_averageDF: the rows are same as previous and each column
#is difference between OI and Truth at each time step, the last column will be average of diffs at each row (location), 3) diff2_rmseDF: rows same as previous but each column will be diff**2 and the last column will be RMSE that is sqrt of average diff**2

#   defined the basin mask
    basin = ReadNETCDF(BasinPath, "basins")
    DA1 = np.empty([len(basin)])
    DA2 = np.empty([len(basin)])
    Openloop = np.empty([len(basin)])
    CMC = np.empty([len(basin)])

    DA1[:] = np.nan
    DA2[:] = np.nan
    Openloop[:] = np.nan 
    CMC[:] = np.nan
   
    CMC_avg = np.empty([SimulationDuration]) 
    model_avg = np.empty([SimulationDuration])
    DA_avg1 = np.empty([SimulationDuration])
    DA_avg2 = np.empty([SimulationDuration])
    model_avg[:] = np.nan
    DA_avg1[:] = np.nan
    DA_avg2[:] = np.nan
    CMC_avg[:] = np.nan

    xx = np.empty([SimulationDuration])
    veg_type_arryay = ReadNETCDF(SpatialPath, "vegetation_category")
    
    for SimDay in range(SimulationDuration):
        #print(SimDay)
        PassedTimeStepNo = (SimDay)
        ThisRestartDate = RestartDate + timedelta(days=PassedTimeStepNo * DeltaTime)
        print(ThisRestartDate)
        xx[SimDay] = SimDay

        thisyear, thismonth, thisday, thishr, thismin, thissec = ThisRestartDate.year, ThisRestartDate.month, ThisRestartDate.day, ThisRestartDate.hour, ThisRestartDate.minute, ThisRestartDate.second
          
# Read DA and open loop data files

        DAFile1 = DAFilePath1+ "/ufs_land_restart_back.%4d-%02d-%02d_%02d-%02d-%02d.nc" % (thisyear, thismonth, thisday, thishr, thismin, thissec)
        DAFile2 = DAFilePath2+ "/ufs_land_restart_back.%4d-%02d-%02d_%02d-%02d-%02d.nc" % (thisyear, thismonth, thisday, thishr, thismin, thissec)
        openloopFile = OpenloopFilePath+ "/ufs_land_restart_back.%4d-%02d-%02d_%02d-%02d-%02d.nc" % (thisyear, thismonth, thisday, thishr, thismin, thissec)
        cmcFile = cmcFilePath+ "/C768_cmc_snow_depth_%4d%02d%02d00.nc" % (thisyear, thismonth, thisday)
        
        DA_array1 = ReadNETCDF(DAFile1, VariName)
        DA_array2 = ReadNETCDF(DAFile2, VariName)
        Openloop_array = ReadNETCDF(openloopFile, VariName)
        cmc_array = ReadNETCDF(cmcFile, 'snowDepth')

        for i in range(len(basin)):
            if basin[i] == 2433:
                if veg_type_arryay[i] != 15 and cmc_array[i] <= 2000.0:
                    DA1[i] = DA_array1[i]
                    DA2[i] = DA_array2[i]
                    Openloop[i] =Openloop_array[i]
                    CMC[i] = cmc_array[i]
        modelavg = np.nanmean(Openloop)
        DAavg1 = np.nanmean(DA1)
        DAavg2 = np.nanmean(DA2)
        model_avg[SimDay] = modelavg
        DA_avg1[SimDay] = DAavg1
        DA_avg2[SimDay] = DAavg2
        cmcavg = np.nanmean(CMC)
        CMC_avg[SimDay] = cmcavg

    plt.figure(figsize=(12,8))
    ax1 = plt.subplot(1, 1, 1)
    ax1.set_ylim(0.0, 300)
    ax1.plot(xx,DA_avg1,'r-',label="GHCN DA")
    ax1.plot(xx,model_avg,'b-',label="openloop")
    ax1.plot(xx,DA_avg2,'g-',label="IMS+GHCN DA")
    ax1.plot(xx,CMC_avg,'k-',label="CMC") 
    ax1.set_ylabel("Snow Depth (mm)", fontsize=20)
    ax1.set_xlabel("Simulation days since 01 October 2019", fontsize=20)
    ax1.set_title("Yangtze River Basin", pad=20, fontsize=20)
    ax1.legend()
    plt.tight_layout()
    plt.savefig(os.path.join(PlotPath, fname))
    plt.close()

SpatialPath = "/scratch2/NCEPDEV/land/data/forcing/era5/static/ufs-land_C768_static_fields.nc"
BasinPath = "/scratch2/NCEPDEV/land/data/evaluation/basins/C768/GRDC_C768.nc"
PlotPath= "./plots/C768_multiYear/"
fname = "Yangtze_river_basin_da_openloop_snowDepth_2mLimit_2019-2020.png"

VarList=["snow_depth"]
for var in VarList:
    Computediff(var)
