import netCDF4
import matplotlib.pyplot as plt
import matplotlib.ticker as mticker
import cartopy.feature as cfeature
import numpy as np
import pandas as pd
import cartopy.crs as ccrs
import os
import sys
from datetime import datetime
from datetime import timedelta

def ReadNETCDF(FilePath, GroupName, VariName):
    f = netCDF4.Dataset(FilePath)
    MyArray = f.groups[GroupName].variables[VariName][:]
    f.close()
    return MyArray

group = "ombg"
varname = "totalSnowDepth" 

daHofxPath1="/scratch2/NCEPDEV/stmp1/Youlong.Xia/landDA/cycle_land/C768/DA_GHCN/DA/hofx"
mdlHofxPath1="/scratch2/NCEPDEV/stmp1/Youlong.Xia/landDA/cycle_land/C768/DAgts_ghcnHOFX/DA/hofx"

daHofxPath2="/scratch2/NCEPDEV/stmp1/Youlong.Xia/landDA/cycle_land/C768/DA_imsGHCN/DA/hofx"
mdlHofxPath2="/scratch2/NCEPDEV/stmp1/Youlong.Xia/landDA/cycle_land/C768/openloop_imsGHCN/DA/hofx"

PlotPath="/scratch1/NCEPDEV/da/Youlong.Xia/DA_plotScripts/pythonScripts/plots/C768/"
fname = PlotPath+group+"_"+varname+"C768_NorthAmerica_gtsDA_ghcnDA_tdev_timeseries_WY2020.png"

RestartDate = "2019-10-01"
DeltaTime = 1  # day
SimulationDuration = 366  # days
RestartDate = datetime.strptime(RestartDate, '%Y-%m-%d')

model_avg12 = np.empty([SimulationDuration])
model_avg22 = np.empty([SimulationDuration])
DA_avg11 = np.empty([SimulationDuration])
DA_avg21 = np.empty([SimulationDuration])
DA_avg31 = np.empty([SimulationDuration])

model_avg12[:] = np.nan
model_avg22[:] = np.nan
DA_avg11[:] = np.nan
DA_avg21[:] = np.nan
DA_avg31[:] = np.nan

xx = np.empty([SimulationDuration])

# North America [-155 - -60oW, 40 - 70oN]
# Europe [0 -45E, 40-70N]
# Russia [45-150, 40-70oN]

latmin = 40.0
latmax = 70.0
lonmin = -155
lonmax = -60

for SimDay in range(SimulationDuration):
    PassedTimeStepNo = (SimDay)
    ThisRestartDate = RestartDate + timedelta(days=PassedTimeStepNo * DeltaTime)
    print(ThisRestartDate)
    str_yr = ThisRestartDate.strftime('%Y')
    str_mh = ThisRestartDate.strftime('%m')
    str_dy = ThisRestartDate.strftime('%d')
    date = str_yr+str_mh+str_dy

    xx[SimDay] = SimDay
    HofxFile11 = daHofxPath1+"/letkf_hofx_ghcn_"+date+"00.nc"     
    HofxFile12 = mdlHofxPath1+"/letkf_hofx_ghcn_"+date+"00.nc"
    HofxFile21 = daHofxPath2+"/letkf_hofx_ghcn_"+date+"00.nc"
    HofxFile22 = mdlHofxPath2+"/letkf_hofx_ghcn_"+date+"00.nc"
    
    ombg11 = ReadNETCDF(HofxFile11 ,"ombg","totalSnowDepth")
    ombg12 = ReadNETCDF(HofxFile12 ,"ombg","totalSnowDepth")
    ombg21 = ReadNETCDF(HofxFile21 ,"ombg","totalSnowDepth")
    ombg22 = ReadNETCDF(HofxFile22 ,"ombg","totalSnowDepth")

    latout =  ReadNETCDF(HofxFile11 ,"MetaData", "latitude")
    lonout = ReadNETCDF(HofxFile11 ,"MetaData", "longitude")

    latout1 =  ReadNETCDF(HofxFile12 ,"MetaData", "latitude")
    lonout1 = ReadNETCDF(HofxFile12 ,"MetaData", "longitude")

    qc11 = ReadNETCDF(HofxFile11,"EffectiveQC0","totalSnowDepth")
    qc12 = ReadNETCDF(HofxFile11,"EffectiveQC1","totalSnowDepth")
    qc21 = ReadNETCDF(HofxFile21,"EffectiveQC0","totalSnowDepth")
    qc22 = ReadNETCDF(HofxFile21,"EffectiveQC1","totalSnowDepth")
    qc31 = ReadNETCDF(HofxFile12,"EffectiveQC0","totalSnowDepth")

    da11 = np.empty([len(latout)])
    da12 = np.empty([len(ombg12)])
    da21 = np.empty([len(latout)])
    da22 = np.empty([len(latout)])
    da31 = np.empty([len(latout1)]) 

    da11[:] = np.nan
    da12[:] = np.nan
    da21[:] = np.nan
    da22[:] = np.nan
    da31[:] = np.nan

    # fill values for a region
    for k in range(len(latout)):
       if (latout[k]>=latmin) & (latout[k]<=latmax) & (lonout[k]>=lonmin) & (lonout[k]<=lonmax):
            if(qc11[k] == 0 and qc12[k] == 0):
                da11[k] = ombg11[k]
                da22[k] = ombg22[k]
                da12[k] = ombg12[k]
            if(qc21[k] == 0 and qc22[k] == 0):
                da21[k] = ombg21[k]

# Use the following constraint and the results are similar to DA GHCN and DA imsGHCN
    for k in range(len(latout1)):
       if (latout1[k]>=latmin) & (latout1[k]<=latmax) & (lonout1[k]>=lonmin) & (lonout1[k]<=lonmax):
            if(qc31[k] == 0):
                da31[k] = ombg12[k]

    avg11= np.nanstd(da11)
    avg12= np.nanstd(da12)
    avg21= np.nanstd(da21)
    avg22= np.nanstd(da22)
    avg31= np.nanstd(da31)

    DA_avg11[SimDay] = avg11
    model_avg12[SimDay] = avg12
    DA_avg21[SimDay] = avg21
    DA_avg31[SimDay] = avg31
    model_avg22[SimDay] = avg22
    #exit()
# plot global averaged snow depth time series
plt.figure(figsize=(12,8))
ax1 = plt.subplot(1, 1, 1)
ax1.set_ylim(0, 200.0)
ax1.plot(xx,model_avg12,'k-',label="DAgts_ghcnHOFX: stdev(O-F)")
ax1.plot(xx,DA_avg11,'r-',label="DA GHCN: stdev(O-F)")
ax1.plot(xx,model_avg22,'b-',label="openloopImsGHCNrun: stdev(O-F)")
ax1.plot(xx,DA_avg21,'g-',label="DA imsGHCN: stdev(O-F)")
ax1.plot(xx,DA_avg31,'c-',label="DAgts_ghcnHOFX_gtsQC: stdev(O-F)")
ax1.set_ylabel("Snow Depth (mm)", fontsize=20)
ax1.set_xlabel("Simulation Days Since 1 October 2019", fontsize=20)
ax1.legend()
plt.tight_layout()
plt.savefig(fname)
plt.close()
