import netCDF4
import matplotlib.pyplot as plt
import matplotlib.ticker as mticker
import cartopy.feature as cfeature
import numpy as np
import pandas as pd
import cartopy.crs as ccrs
import os
import sys
from datetime import datetime
from datetime import timedelta

def ReadNETCDF(FilePath, GroupName, VariName):
    f = netCDF4.Dataset(FilePath)
    MyArray = f.groups[GroupName].variables[VariName][:]
    f.close()
    return MyArray

group = "ombg"
varname = "totalSnowDepth" 


daHofxPath1="/scratch2/NCEPDEV/stmp1/Youlong.Xia/landDA/cycle_land/C768/DAimsGTS//DA/hofx"
mdlHofxPath1="/scratch2/NCEPDEV/stmp1/Youlong.Xia/landDA/cycle_land/C768/openHOFX_imsGTS/DA/hofx"

PlotPath="/scratch1/NCEPDEV/da/Youlong.Xia/DA_plotScripts/pythonScripts/plots/C768_multiYear/"
fname = PlotPath+group+"_"+varname+"C768_EuropeGTS_stdev_timeseries_WY2020.png"

RestartDate = "2019-10-01"
DeltaTime = 1  # day
SimulationDuration = 210  # days
RestartDate = datetime.strptime(RestartDate, '%Y-%m-%d')

model_avg1 = np.empty([SimulationDuration])
model_avg2 = np.empty([SimulationDuration])
model_avg3 = np.empty([SimulationDuration])
model_avg4 = np.empty([SimulationDuration])
DA_avg1 = np.empty([SimulationDuration])
DA_avg2 = np.empty([SimulationDuration])
DA_avg3 = np.empty([SimulationDuration])
DA_avg4 = np.empty([SimulationDuration])

model_avg1[:] = np.nan
model_avg2[:] = np.nan
model_avg3[:] = np.nan
model_avg4[:] = np.nan
DA_avg1[:] = np.nan
DA_avg2[:] = np.nan
DA_avg3[:] = np.nan
DA_avg4[:] = np.nan

xx = np.empty([SimulationDuration])

# North America [-155 - -60oW, 40 - 70oN]
# Europe [0 -45E, 40-70N]
# Russia [45-150, 40-70oN]

latmin = 40.0
latmax = 70.0
lonmin = 0
lonmax = 45

for SimDay in range(SimulationDuration):
    PassedTimeStepNo = (SimDay)
    ThisRestartDate = RestartDate + timedelta(days=PassedTimeStepNo * DeltaTime)
    print(ThisRestartDate)
    str_yr = ThisRestartDate.strftime('%Y')
    str_mh = ThisRestartDate.strftime('%m')
    str_dy = ThisRestartDate.strftime('%d')
    date = str_yr+str_mh+str_dy

    xx[SimDay] = SimDay
    HofxFile11 = daHofxPath1+"/letkf_hofx_gts_"+date+"00.nc"
    HofxFile21 = mdlHofxPath1+"/letkf_hofx_gts_"+date+"00.nc"

    HofxFile12 = daHofxPath1+"/letkf_hofx_gts_"+date+"06.nc"
    HofxFile22 = mdlHofxPath1+"/letkf_hofx_gts_"+date+"06.nc"

    HofxFile13 = daHofxPath1+"/letkf_hofx_gts_"+date+"12.nc"
    HofxFile23 = mdlHofxPath1+"/letkf_hofx_gts_"+date+"12.nc"

    HofxFile14 = daHofxPath1+"/letkf_hofx_gts_"+date+"18.nc"
    HofxFile24 = mdlHofxPath1+"/letkf_hofx_gts_"+date+"18.nc"

    ombg11 = ReadNETCDF(HofxFile11 ,"ombg","totalSnowDepth")
    ombg21 = ReadNETCDF(HofxFile21 ,"ombg","totalSnowDepth")

    ombg12 = ReadNETCDF(HofxFile12 ,"ombg","totalSnowDepth")
    ombg22 = ReadNETCDF(HofxFile22 ,"ombg","totalSnowDepth")

    ombg13 = ReadNETCDF(HofxFile13 ,"ombg","totalSnowDepth")
    ombg23 = ReadNETCDF(HofxFile23 ,"ombg","totalSnowDepth")

    ombg14 = ReadNETCDF(HofxFile14 ,"ombg","totalSnowDepth")
    ombg24 = ReadNETCDF(HofxFile24 ,"ombg","totalSnowDepth")

    latout11 = ReadNETCDF(HofxFile11 ,"MetaData", "latitude")
    lonout21 = ReadNETCDF(HofxFile11 ,"MetaData", "longitude")

    latout12 = ReadNETCDF(HofxFile12 ,"MetaData", "latitude")
    lonout22 = ReadNETCDF(HofxFile12 ,"MetaData", "longitude")

    latout13 = ReadNETCDF(HofxFile13 ,"MetaData", "latitude")
    lonout23 = ReadNETCDF(HofxFile13 ,"MetaData", "longitude")

    latout14 = ReadNETCDF(HofxFile14 ,"MetaData", "latitude")
    lonout24 = ReadNETCDF(HofxFile14 ,"MetaData", "longitude")

    qc11 = ReadNETCDF(HofxFile11,"EffectiveQC0","totalSnowDepth")
    qc21 = ReadNETCDF(HofxFile11,"EffectiveQC1","totalSnowDepth")

    qc12 = ReadNETCDF(HofxFile12,"EffectiveQC0","totalSnowDepth")
    qc22 = ReadNETCDF(HofxFile12,"EffectiveQC1","totalSnowDepth")

    qc13 = ReadNETCDF(HofxFile13,"EffectiveQC0","totalSnowDepth")
    qc23 = ReadNETCDF(HofxFile13,"EffectiveQC1","totalSnowDepth")

    qc14 = ReadNETCDF(HofxFile14,"EffectiveQC0","totalSnowDepth")
    qc24 = ReadNETCDF(HofxFile14,"EffectiveQC1","totalSnowDepth")

    da11 = np.empty([len(latout11)])
    da21 = np.empty([len(latout11)])
    da12 = np.empty([len(latout12)])
    da22 = np.empty([len(latout12)])
    da13 = np.empty([len(latout13)])
    da23 = np.empty([len(latout13)])
    da14 = np.empty([len(latout14)])
    da24 = np.empty([len(latout14)])

    da11[:] = np.nan
    da21[:] = np.nan
    da12[:] = np.nan
    da22[:] = np.nan
    da13[:] = np.nan
    da23[:] = np.nan
    da14[:] = np.nan
    da24[:] = np.nan

    # fill values for a region
    for k in range(len(latout11)):
        if (latout11[k]>=latmin) & (latout11[k]<=latmax) & (lonout21[k]>=lonmin) & (lonout21[k]<=lonmax):
            #if(qc11[k] == 0 and qc12[k] == 0):
            if(qc11[k] == 0):
                da11[k]=ombg11[k]
                da21[k]=ombg21[k]
 
    for k in range(len(latout12)):
        if (latout12[k]>=latmin) & (latout12[k]<=latmax) & (lonout22[k]>=lonmin) & (lonout22[k]<=lonmax):
            if(qc12[k] == 0 and qc22[k] == 0):
                da12[k]=ombg12[k]
                da22[k]=ombg22[k]

    for k in range(len(latout13)):
       if (latout13[k]>=latmin) & (latout13[k]<=latmax) & (lonout23[k]>=lonmin) & (lonout23[k]<=lonmax):
            if(qc13[k] == 0 and qc23[k] == 0):
                da13[k]=ombg13[k]
                da23[k]=ombg23[k]

    for k in range(len(latout14)):
       if (latout14[k]>=latmin) & (latout14[k]<=latmax) & (lonout24[k]>=lonmin) & (lonout24[k]<=lonmax):
            if(qc14[k] == 0 and qc24[k] == 0):
                da14[k]=ombg14[k]
                da24[k]=ombg24[k]

    avg11= np.nanstd(da11)
    avg21= np.nanstd(da21)

    avg12= np.nanstd(da12)
    avg22= np.nanstd(da22)

    avg13= np.nanstd(da13)
    avg23= np.nanstd(da23)

    avg14= np.nanstd(da14)
    avg24= np.nanstd(da24)

    DA_avg1[SimDay] = avg11
    model_avg1[SimDay] = avg21

    DA_avg2[SimDay] = avg12
    model_avg2[SimDay] = avg22

    DA_avg3[SimDay] = avg13
    model_avg3[SimDay] = avg23

    DA_avg4[SimDay] = avg14
    model_avg4[SimDay] = avg24


# plot global averaged snow depth time series
plt.figure(figsize=(12,8))
ax1 = plt.subplot(1, 1, 1)
ax1.set_ylim(0, 250.0)
ax1.plot(xx,model_avg1,'b.',label="Open loop 00Z: stdev(O-F)")
ax1.plot(xx,model_avg2,'k.',label="Open loop 06Z: stdev(O-F)")
ax1.plot(xx,model_avg3,'g.',label="Open loop 12Z: stdev(O-F)")
ax1.plot(xx,model_avg4,'r.',label="Open loop 18Z: stdev(O-F)")
ax1.plot(xx,DA_avg1,'b-',label="DAimsGTS 00Z: stdev(O-F)")
ax1.plot(xx,DA_avg2,'k-',label="DAimsGTS 06Z: stdev(O-F)")
ax1.plot(xx,DA_avg3,'g-',label="DAimsGTS 12Z: stdev(O-F)")
ax1.plot(xx,DA_avg4,'r-',label="DAimsGTS 18Z: stdev(O-F)")
ax1.set_ylabel("Snow Depth (mm)", fontsize=20)
ax1.set_title("Europe", fontsize=20)
ax1.set_xlabel("Simulation Days Since 1 October 2019", fontsize=20)
ax1.legend()
plt.tight_layout()
plt.savefig(fname)
plt.close()
