import netCDF4
import matplotlib.pyplot as plt
import matplotlib.ticker as mticker
import cartopy.feature as cfeature
import numpy as np
import pandas as pd
import cartopy.crs as ccrs
import os
import sys
from datetime import datetime
from datetime import timedelta

def ReadNETCDF(FilePath, GroupName, VariName):
    f = netCDF4.Dataset(FilePath)
    MyArray = f.groups[GroupName].variables[VariName][:]
    f.close()
    return MyArray

group = "ombg"
varname = "totalSnowDepth" 

daHofxPath1="/scratch1/NCEPDEV/stmp4/Youlong.Xia/landDA/cycle_land/C768/DA_GHCN_2015to2020/DA/hofx"
mdlHofxPath1="/scratch1/NCEPDEV/stmp4/Youlong.Xia/landDA/cycle_land/C768/openloop_ghcnHOFX_2015to2020/DA/hofx"
daHofxPath2="/scratch2/NCEPDEV/stmp3/Youlong.Xia/landDA/cycle_land/C768/DA_imsGHCN_2015to2020/DA/hofx"

PlotPath="/scratch1/NCEPDEV/da/Youlong.Xia/DA_plotScripts/pythonScripts/plots/C768_multiYear/"
fname = PlotPath+"Station_Number_westernUS_timeseries_WY2015-2020.png"

RestartDate = "2015-10-01"
DeltaTime = 1  # day
SimulationDuration = 1825  # days
#SimulationDuration = 365  # days
RestartDate = datetime.strptime(RestartDate, '%Y-%m-%d')

model_avg12 = np.empty([SimulationDuration])
DA_avg11 = np.empty([SimulationDuration])
DA_avg21 = np.empty([SimulationDuration])

model_avg12[:] = np.nan
DA_avg11[:] = np.nan
DA_avg21[:] = np.nan

xx = np.empty([SimulationDuration])

# North America [-155 - -60oW, 40 - 70oN]
# Europe [0 -45E, 40-70N]
# Russia [45-150, 40-70oN]
# Wstern Mountainous region

latmin = 35.0
latmax = 50.0
lonmin = -125
lonmax = -100

for SimDay in range(SimulationDuration):
    PassedTimeStepNo = (SimDay)
    ThisRestartDate = RestartDate + timedelta(days=PassedTimeStepNo * DeltaTime)
    print(ThisRestartDate)
    str_yr = ThisRestartDate.strftime('%Y')
    str_mh = ThisRestartDate.strftime('%m')
    str_dy = ThisRestartDate.strftime('%d')
    date = str_yr+str_mh+str_dy

    xx[SimDay] = SimDay
    HofxFile11 = daHofxPath1+"/letkf_hofx_ghcn_"+date+"00.nc"     
    HofxFile12 = mdlHofxPath1+"/letkf_hofx_ghcn_"+date+"00.nc"
    HofxFile21 = daHofxPath2+"/letkf_hofx_ghcn_"+date+"00.nc"
    
    ombg11 = ReadNETCDF(HofxFile11 ,"ombg","totalSnowDepth")
    ombg12 = ReadNETCDF(HofxFile12 ,"ombg","totalSnowDepth")
    ombg21 = ReadNETCDF(HofxFile21 ,"ombg","totalSnowDepth")

    latout =  ReadNETCDF(HofxFile11 ,"MetaData", "latitude")
    lonout = ReadNETCDF(HofxFile11 ,"MetaData", "longitude")
    elavation = ReadNETCDF(HofxFile11 ,"MetaData", "height")

    qc11 = ReadNETCDF(HofxFile11,"EffectiveQC0","totalSnowDepth")
    qc12 = ReadNETCDF(HofxFile11,"EffectiveQC1","totalSnowDepth")
    qc21 = ReadNETCDF(HofxFile21,"EffectiveQC0","totalSnowDepth")
    qc22 = ReadNETCDF(HofxFile21,"EffectiveQC1","totalSnowDepth")

    da11 = np.empty([len(latout)])
    da12 = np.empty([len(latout)])
    da21 = np.empty([len(latout)])

    da11[:] = np.nan
    da12[:] = np.nan
    da21[:] = np.nan

    # fill values for a region
    k1=0
    k2=0
    k3=0
    for k in range(len(latout)):
       if (latout[k]>=latmin) & (latout[k]<=latmax) & (lonout[k]>=lonmin) & (lonout[k]<=lonmax):
            k1=k1+1
            if(qc11[k] == 0 and qc12[k] == 0):
                k2=k2+1
                if (elavation[k] >=1500.0):
                    k3=k3+1
    avg11= np.nanstd(da11)
    avg12= np.nanstd(da12)
    avg21= np.nanstd(da21)

    DA_avg11[SimDay] = k2
    model_avg12[SimDay] = k1
    DA_avg21[SimDay] = k3
    #exit()
# plot global averaged snow depth time series
plt.figure(figsize=(12,8))
ax1 = plt.subplot(1, 1, 1)
ax1.set_ylim(0, 5000.0)
ax1.plot(xx,model_avg12,'b-',label="total station number")
ax1.plot(xx,DA_avg11,'r-',label="station number used")
ax1.plot(xx,DA_avg21,'g-',label="station number used with higher than 1500m")
ax1.set_ylabel("Snow Depth (mm)", fontsize=20)
ax1.set_xlabel("Simulation Days Since 1 October 2015", fontsize=20)
ax1.set_title("Western US [100-125oW, 35-50oN]") 
ax1.legend()
plt.tight_layout()
plt.savefig(fname)
plt.close()
