import netCDF4
import matplotlib.pyplot as plt
import matplotlib.ticker as mticker
import cartopy.feature as cfeature
import numpy as np
import pandas as pd
import cartopy.crs as ccrs
import os
import sys
from datetime import datetime
from datetime import timedelta

def ReadNETCDF(FilePath, GroupName, VariName):
    f = netCDF4.Dataset(FilePath)
    MyArray = f.groups[GroupName].variables[VariName][:]
    f.close()
    return MyArray

group = "ombg"
varname = "totalSnowDepth" 

daHofxPath1="/scratch2/NCEPDEV/stmp1/Youlong.Xia/landDA/cycle_land/C768/DAimsGTS/DA/hofx"
mdlHofxPath1="/scratch2/NCEPDEV/stmp1/Youlong.Xia/landDA/cycle_land/C768/openHOFX_imsGTS/DA/hofx"

daHofxPath2="/scratch2/NCEPDEV/stmp1/Youlong.Xia/landDA/cycle_land/C768/DA_imsGHCN/DA/hofx"

mdlHofxPath2="/scratch2/NCEPDEV/stmp1/Youlong.Xia/landDA/cycle_land/C768/openloop_imsGHCN/DA/hofx"

PlotPath="/scratch1/NCEPDEV/da/Youlong.Xia/DA_plotScripts/pythonScripts/plots/C768/"
fname = PlotPath+"GTS_GHCN_stationNumber_timeseries_WY2020.png"

RestartDate = "2019-10-01"
DeltaTime = 1  # day
SimulationDuration = 336  # days
RestartDate = datetime.strptime(RestartDate, '%Y-%m-%d')

model_avg12 = np.empty([SimulationDuration])
model_avg22 = np.empty([SimulationDuration])
DA_avg11 = np.empty([SimulationDuration])
DA_avg21 = np.empty([SimulationDuration])

model_avg12[:] = np.nan
model_avg22[:] = np.nan
DA_avg11[:] = np.nan
DA_avg21[:] = np.nan

xx = np.empty([SimulationDuration])

for SimDay in range(SimulationDuration):
    PassedTimeStepNo = (SimDay)
    ThisRestartDate = RestartDate + timedelta(days=PassedTimeStepNo * DeltaTime)
    print(ThisRestartDate)
    str_yr = ThisRestartDate.strftime('%Y')
    str_mh = ThisRestartDate.strftime('%m')
    str_dy = ThisRestartDate.strftime('%d')
    date = str_yr+str_mh+str_dy

    xx[SimDay] = SimDay
    HofxFile11 = daHofxPath1+"/letkf_hofx_gts_"+date+"00.nc"     
    HofxFile12 = mdlHofxPath1+"/letkf_hofx_gts_"+date+"00.nc"
    HofxFile21 = daHofxPath2+"/letkf_hofx_ghcn_"+date+"00.nc"
    HofxFile22 = mdlHofxPath2+"/letkf_hofx_ghcn_"+date+"00.nc"
    
    ombg11 = ReadNETCDF(HofxFile11 ,"ombg","totalSnowDepth")
    ombg12 = ReadNETCDF(HofxFile12 ,"ombg","totalSnowDepth")
    ombg21 = ReadNETCDF(HofxFile21 ,"ombg","totalSnowDepth")
    ombg22 = ReadNETCDF(HofxFile22 ,"ombg","totalSnowDepth")

    qc11 = ReadNETCDF(HofxFile11,"EffectiveQC0","totalSnowDepth")
    qc12 = ReadNETCDF(HofxFile11,"EffectiveQC1","totalSnowDepth")
    qc21 = ReadNETCDF(HofxFile21,"EffectiveQC0","totalSnowDepth")
    qc22 = ReadNETCDF(HofxFile21,"EffectiveQC1","totalSnowDepth")

    k1=0.0
    k2=0.0
    for i in range(len(ombg11)):
        if(qc11[i] == 0 and qc12[i] == 0):
           k1=k1+1.0
    for i in range(len(ombg21)):
        if(qc21[i] == 0 and qc22[i] == 0):
           k2=k2+1.0

    DA_avg11[SimDay] = k1
    DA_avg21[SimDay] = k2

# plot global averaged snow depth time series
plt.figure(figsize=(12,8))
ax1 = plt.subplot(1, 1, 1)
ax1.set_ylim(0, 10000.0)
ax1.plot(xx,DA_avg11,'r-',label="GTS station number")
ax1.plot(xx,DA_avg21,'g-',label="GNCN staion number")
ax1.set_ylabel("Snow Station Number", fontsize=20)
ax1.set_xlabel("Simulation Days Since 1 October 2019", fontsize=20)
ax1.legend()
plt.tight_layout()
plt.savefig(fname)
plt.close()
