import netCDF4
import matplotlib.pyplot as plt
import cartopy.feature as cfeature
import numpy as np
import pandas as pd
import cartopy.crs as ccrs
import os
from datetime import datetime
from datetime import timedelta
from dateutil.relativedelta import relativedelta

def ReadNETCDF(FilePath, VariName):
    f = netCDF4.Dataset(FilePath)
    MyArray = f.variables[VariName][:].ravel()
    return MyArray

def ReadNETCDF_2D(FilePath, VariName):
    f = netCDF4.Dataset(FilePath)
    MyArray = f.variables[VariName][:]
    return MyArray

def Computediff(VariName):
    print(VariName)
    DAFilePath="//scratch2/NCEPDEV/land/Youlong.Xia/landDA/cycle_land/DA_era5/mem000/restarts/vector"
    OpenloopFilePath="/scratch2/NCEPDEV/land/Youlong.Xia/landDA/cycle_land/openloop_era5/mem000/restarts/vector"
    modisFilePath="/scratch2/NCEPDEV/land/data/evaluation/MODIS/albedo/C96/"

    fname = "Russia_"+VariName+"_timeseries.png"

    RestartDate = "2019-10-01_18-00-00"
    DeltaTime = 1  # day
    SimulationDuration = 244  # days
    simuMonth = 8 # months    

    RestartDate = datetime.strptime(RestartDate, '%Y-%m-%d_%H-%M-%S')
#we want to create 3 dataframe: 1) Truth_stdDF: the rows are locations and columns are truth value at each time step and the last column will be the standard deviation of truth, 2) diff_averageDF: the rows are same as previous and each column
#is difference between OI and Truth at each time step, the last column will be average of diffs at each row (location), 3) diff2_rmseDF: rows same as previous but each column will be diff**2 and the last column will be RMSE that is sqrt of average diff**2

#   defined the basin mask
    basin = ReadNETCDF(BasinPath, "basins")

    DA = np.empty([len(basin)])
    Openloop = np.empty([len(basin)])
    modis =  np.empty([len(basin)])
    DA_albedo = np.empty([len(basin)])
    open_albedo = np.empty([len(basin)])

    DA[:] = np.nan
    Openloop[:] = np.nan
    modis[:] = np.nan 
   
    modis_avg = np.empty([SimulationDuration]) 
    model_avg = np.empty([SimulationDuration])
    DA_avg = np.empty([SimulationDuration])
    model_avg[:] = np.nan
    DA_avg[:] = np.nan
    modis_avg[:] = np.nan

    xx = np.empty([SimulationDuration])

    # North America [205 - 300o, 30 -70oN]
    # Europe [0 -45E, 40-70N]
    # Russia [45-150, 40-70]

    latmin = 40
    latmax = 70.0
    lonmin = 45.0
    lonmax = 150.0
    
    for SimDay in range(SimulationDuration):
        print(SimDay)
        PassedTimeStepNo = (SimDay)
        ThisRestartDate = RestartDate + timedelta(days=PassedTimeStepNo * DeltaTime)
        print(ThisRestartDate)
        xx[SimDay] = SimDay

        thisyear, thismonth, thisday, thishr, thismin, thissec = ThisRestartDate.year, ThisRestartDate.month, ThisRestartDate.day, ThisRestartDate.hour, ThisRestartDate.minute, ThisRestartDate.second

        str_yr = ThisRestartDate.strftime('%Y')
        str_mh = ThisRestartDate.strftime('%m')
        str_dy = ThisRestartDate.strftime('%d')
        day_str = str_yr+str_mh+str_dy
          
# Read DA and open loop data files
        modisFile = modisFilePath+"MCD43C3.A"+day_str+".061.C96.nc"
        DAFile = DAFilePath+ "/ufs_land_restart_back.%4d-%02d-%02d_%02d-%02d-%02d.nc" % (thisyear, thismonth, thisday, thishr, thismin, thissec)
        openloopFile = OpenloopFilePath+ "/ufs_land_restart_back.%4d-%02d-%02d_%02d-%02d-%02d.nc" % (thisyear, thismonth, thisday, thishr, thismin, thissec)

        if (SimDay == 0):
            latout = ReadNETCDF(modisFile, "lat")
            lonout = ReadNETCDF(modisFile, "lon")

        if (VariName == "albedo_direct"):
            modis_array = ReadNETCDF(modisFile, "albedo_bsa_shortwave")
        else:
            modis_array = ReadNETCDF(modisFile, "albedo_wsa_shortwave")

        DA_array = ReadNETCDF_2D(DAFile, VariName)
        #print(DA_array.size, DA_array.shape, DA_array.ndim)
        DA_albedo =0.5*(DA_array[0,0,:]+DA_array[0,1,:])

        Openloop_array = ReadNETCDF_2D(openloopFile, VariName)
        open_albedo = 0.5*(Openloop_array[0,0,:]+Openloop_array[0,1,:])

        for i in range(len(basin)):
            if (latout[i]>=latmin) & (latout[i]<=latmax) & (lonout[i]>=lonmin) & (lonout[i]<=lonmax):
                if (modis_array[i] > 0.0): 
                    DA[i] = DA_albedo[i]
                    Openloop[i] = open_albedo[i]
                    modis[i] = modis_array[i]
        modelavg = np.nanmean(Openloop)
        DAavg = np.nanmean(DA)
        modisavg =  np.nanmean(modis)
        model_avg[SimDay] = modelavg
        DA_avg[SimDay] = DAavg
        modis_avg[SimDay] = modisavg

    plt.figure(figsize=(12,8))
    ax1 = plt.subplot(1, 1, 1)
    ax1.set_ylim(0.0, 0.6)
    ax1.plot(xx,model_avg,'b-',label="openloop")
    ax1.plot(xx,DA_avg,'r-',label="DA")
    ax1.plot(xx,modis_avg,'k-',label="MODIS") 
    ax1.set_ylabel("albedo", fontsize=20)
    ax1.set_xlabel("Simulation days since 01 October 2019", fontsize=20)
    ax1.set_title(VariName+" comparison in Russia", pad=20, fontsize=20)
    ax1.legend()
    plt.tight_layout()
    plt.savefig(fname)
    plt.close()
    
BasinPath = "/scratch2/NCEPDEV/land/data/evaluation/basins/C96/GRDC_C96.nc"
PlotPath= "/scratch2/NCEPDEV/land/Youlong.Xia/landDA/plots/C96/Average_DA-OpenLoopDiffsnap/"
RMSEplot= "/scratch2/NCEPDEV/land/Youlong.Xia/landDA/plots/C96/RMSE_DA-OpenLoopDiffsnap/"


VarList=["albedo_direct", "albedo_diffuse"]
for var in VarList:
    Computediff(var)
