import netCDF4
import matplotlib.pyplot as plt
import cartopy.feature as cfeature
import numpy as np
import pandas as pd
import cartopy.crs as ccrs
import os
from datetime import datetime
from datetime import timedelta

def ReadNETCDF(FilePath, VariName):
    f = netCDF4.Dataset(FilePath)
    MyArray = f.variables[VariName][:]
    return MyArray

def Computediff(VariName):
    print(VariName)
    DAFilePath="/scratch2/NCEPDEV/stmp3/Youlong.Xia/landDA/cycle_land/C768/DA_imsGHCN_2015to2020/mem000/restarts/vector"
    cmcFilePath="/scratch2/NCEPDEV/land/data/evaluation/CMC/FV3ufsLand/C768"
  
    RestartDate = "2020-07-15_00-00-00"
    DeltaTime = 1  # day
    SimulationDuration = 1  # days
    RestartDate = datetime.strptime(RestartDate, '%Y-%m-%d_%H-%M-%S')
#we want to create 3 dataframe: 1) Truth_stdDF: the rows are locations and columns are truth value at each time step and the last column will be the standard deviation of truth, 2) diff_averageDF: the rows are same as previous and each column
#is difference between OI and Truth at each time step, the last column will be average of diffs at each row (location), 3) diff2_rmseDF: rows same as previous but each column will be diff**2 and the last column will be RMSE that is sqrt of average diff**2
    Openloop_stdDF = pd.DataFrame()
    diff_averageDF=pd.DataFrame()
    diff2_rmseDF = pd.DataFrame()

#   defined the basin mask
    basin = ReadNETCDF(BasinPath, "basins")
    DA = np.empty([len(basin)])
    CMC = np.empty([len(basin)])

    DA[:] = 10.0
    CMC[:] = 10.0
    
    for SimDay in range(SimulationDuration):
        PassedTimeStepNo = (SimDay)
        ThisRestartDate = RestartDate + timedelta(days=PassedTimeStepNo * DeltaTime)
        print(ThisRestartDate)
        thisyear, thismonth, thisday, thishr, thismin, thissec = ThisRestartDate.year, ThisRestartDate.month, ThisRestartDate.day, ThisRestartDate.hour, ThisRestartDate.minute, ThisRestartDate.second
        DAFile = DAFilePath+ "/ufs_land_restart_anal.%4d-%02d-%02d_%02d-%02d-%02d.nc" % (thisyear, thismonth, thisday, thishr, thismin, thissec)
        openloopFile = cmcFilePath+ "/C768_cmc_snow_depth_%4d%02d%02d00.nc" % (thisyear, thismonth, thisday)

        DA_array = ReadNETCDF(DAFile , VariName)
        Openloop_array = ReadNETCDF(openloopFile , 'snowDepth')
        
        for i in range(len(basin)):
            if basin[i] == 2433 or basin[i] == 2434:
                DA[i]=DA_array[0, i]
                CMC[i]=Openloop_array[0, i]
        Diff = DA-CMC

        Openloop_stdDF["%d_Openloop"% SimDay]=CMC
        diff_averageDF["%d_diff" % SimDay] = Diff
        diff2_rmseDF["%d_diff2" % SimDay] = Diff**2

    Openloop_stdDF["stdOfOpenloop"]=Openloop_stdDF.std(axis=1)
    diff_averageDF["MeanOFDiffs"] = diff_averageDF.mean(axis=1)
    diff2_rmseDF["MeanOFDiff2"] = diff2_rmseDF.mean(axis=1)

    diff2_rmseDF["MeanOFDiffs"]=diff_averageDF["MeanOFDiffs"]
    Long = ReadNETCDF(SpatialPath, "longitude")
    Lat = ReadNETCDF(SpatialPath, "latitude")
    diff2_rmseDF["Lat"] = Lat
    diff2_rmseDF["Long"] = Long
    diff2_rmseDF["ID"] = np.arange(1, len(diff2_rmseDF) + 1)
    # Openloop_stdDF.to_csv("test.csv", index=False)

    # maxvalue = diff2_rmseDF["MeanOFDiffs"].max()
    # maxvalueID=np.argmax(diff2_rmseDF["MeanOFDiffs"])
    # print("maxMeanID=%s"%maxvalueID)

    #now we want to mask poles locations that are where veg_type==15 ( glaciers  - we're not doing any DA here)
    veg_type_arryay = ReadNETCDF(SpatialPath, "vegetation_category")
    CurrentMeanResult=diff2_rmseDF.MeanOFDiffs
    MaskedMeanResult=np.where(veg_type_arryay==15,0,CurrentMeanResult)
    maxvalue = MaskedMeanResult.max()
    maxvalue=round(maxvalue,3)
    minvalue = MaskedMeanResult.min()
    minvalue=round(minvalue,3)
    
    fig = plt.figure(figsize=(12, 8))
    ax = fig.add_subplot(1, 1, 1, projection=ccrs.PlateCarree(central_longitude=0))
    # Plot grid lines
# ----------------
    gl = ax.gridlines(crs=ccrs.PlateCarree(central_longitude=0), draw_labels=True,linewidth=1, color='gray', alpha=0.5, linestyle='-')
    gl.top_labels = False
    gl.xlabel_style = {'size': 10, 'color': 'black'}
    gl.ylabel_style = {'size': 10, 'color': 'black'}
    ax.add_feature(cfeature.GSHHSFeature(scale='auto'))
    cs = plt.scatter(x=diff2_rmseDF.Long, y=diff2_rmseDF.Lat, c=MaskedMeanResult, cmap="pink", marker=',', s=10, vmax=100, vmin=-8000, transform=ccrs.PlateCarree())
    cb = plt.colorbar(cs, orientation='horizontal', shrink=0.5, pad=.04)
    cb.set_label("%s ghcnDA-CMC Mean"%VariName, fontsize=12)
# Plot regionally
# --------------
    ax.set_extent([85, 115, 25, 50])
    plt.title("Max=%s Min=%s 20200715" % (maxvalue, minvalue), fontsize=12)    
    plt.savefig(os.path.join(PlotPath, "%s_DA-CMC_YangtzeYellow_20200715.png"%VariName))
    plt.close()

SpatialPath = "/scratch2/NCEPDEV/land/data/forcing/era5/static/ufs-land_C768_static_fields.nc"
BasinPath = "/scratch2/NCEPDEV/land/data/evaluation/basins/C768/GRDC_C768.nc"
PlotPath= "./plots/C768_multiYear/"


VarList=["snow_depth"]
for var in VarList:
    Computediff(var)
