import netCDF4
import matplotlib.pyplot as plt
import cartopy.feature as cfeature
import numpy as np
import pandas as pd
import cartopy.crs as ccrs
import os
from datetime import datetime
from datetime import timedelta

def ReadNETCDF(FilePath, VariName):
    f = netCDF4.Dataset(FilePath)
    MyArray = f.variables[VariName][:]
    return MyArray

def Computediff(VariName):
    print(VariName)
    DAFilePath="/scratch1/NCEPDEV/da/Azadeh.Gholoubi/jedi_experiment2/cycleDA/output/restarts/vector/"
    OpenloopFilePath="/scratch1/NCEPDEV/da/Azadeh.Gholoubi/Openloop/cycleDA/output/restarts/vector/"
    RestartDate = "2015-09-01_18-00-00"
    DeltaTime = 1  # day
    SimulationDuration = 243  # days
    RestartDate = datetime.strptime(RestartDate, '%Y-%m-%d_%H-%M-%S')
#we want to create 3 dataframe: 1) Truth_stdDF: the rows are locations and columns are truth value at each time step and the last column will be the standard deviation of truth, 2) diff_averageDF: the rows are same as previous and each column
#is difference between OI and Truth at each time step, the last column will be average of diffs at each row (location), 3) diff2_rmseDF: rows same as previous but each column will be diff**2 and the last column will be RMSE that is sqrt of average diff**2
    Openloop_stdDF = pd.DataFrame()
    diff_averageDF=pd.DataFrame()
    diff2_rmseDF = pd.DataFrame()
    diff_AbsBiasDF = pd.DataFrame()

    for SimDay in range(SimulationDuration):
        PassedTimeStepNo = (SimDay)
        ThisRestartDate = RestartDate + timedelta(days=PassedTimeStepNo * DeltaTime)
        print(ThisRestartDate)
        thisyear, thismonth, thisday, thishr, thismin, thissec = ThisRestartDate.year, ThisRestartDate.month, ThisRestartDate.day, ThisRestartDate.hour, ThisRestartDate.minute, ThisRestartDate.second
        DAFile = DAFilePath+ "/ufs_land_restart_back.%4d-%02d-%02d_%02d-%02d-%02d.nc" % (thisyear, thismonth, thisday, thishr, thismin, thissec)
        openloopFile = OpenloopFilePath+ "/ufs_land_restart_back.%4d-%02d-%02d_%02d-%02d-%02d.nc" % (thisyear, thismonth, thisday, thishr, thismin, thissec)
        DA_array = ReadNETCDF(DAFile , VariName)
        Openloop_array = ReadNETCDF(openloopFile , VariName)
        if len(DA_array.shape) == 3:
            DA=DA_array[0, 0, :]
            Openloop=Openloop_array[0, 0, :]
            Diff = Gdas-Openloop
            #only where Openloop has snow at least once.
            Diff = np.where(Openloop== 0, np.nan, Diff)
            absDiff=abs(Diff)

        elif len(DA_array.shape) == 2:
            DA= DA_array[0, :]
            Openloop=Openloop_array[0, :]
            Diff = DA-Openloop
            Diff = np.where(Openloop== 0, np.nan, Diff)
            absDiff = abs(Diff)

        else:
            print("Check the shape of array!")
            exit()
        Openloop_stdDF["%d_Openloop"% SimDay]=Openloop

        diff_averageDF["%d_diff" % SimDay] = Diff

        diff2_rmseDF["%d_diff2" % SimDay] = Diff**2

        diff_AbsBiasDF["%d_diffAbs" % SimDay] = absDiff

    Openloop_stdDF["stdOfOpenloop"]=Openloop_stdDF.std(axis=1)

    diff_averageDF["MeanOFDiffs"] = diff_averageDF.mean(axis=1)

    diff2_rmseDF["MeanOFDiff2"] = diff2_rmseDF.mean(axis=1)

    diff_AbsBiasDF["AbsMeanOFDiff"] = diff_AbsBiasDF.mean(axis=1)

    diff2_rmseDF["RMSEOFDiff2"] = np.sqrt(diff2_rmseDF["MeanOFDiff2"])

    diff2_rmseDF["NormalizedRMSE"]=diff2_rmseDF["RMSEOFDiff2"]/Openloop_stdDF["stdOfOpenloop"]
    diff2_rmseDF["MeanOFDiffs"]=diff_averageDF["MeanOFDiffs"]
    diff2_rmseDF["AbsMeanOFDiff"] = diff_AbsBiasDF["AbsMeanOFDiff"]

    Long = ReadNETCDF(SpatialPath, "longitude")
    Lat = ReadNETCDF(SpatialPath, "latitude")
    diff2_rmseDF["Lat"] = Lat
    diff2_rmseDF["Long"] = Long
    diff2_rmseDF["ID"] = np.arange(1, len(diff2_rmseDF) + 1)

    #now we want to mask ploes locations that are where veg_type==15 ( glaciers  - we're not doing any DA here)
    veg_type_arryay = ReadNETCDF(SpatialPath, "vegetation_category")
    CurrentMeanResult=diff2_rmseDF.MeanOFDiffs
    MaskedMeanResult=np.where(veg_type_arryay==15,np.nan,CurrentMeanResult)

    CurrentRMSEResult = diff2_rmseDF.RMSEOFDiff2
    MaskedRMSEResult = np.where(veg_type_arryay == 15, np.nan, CurrentRMSEResult)

    CurrentNormalizedRMSEResult = diff2_rmseDF.NormalizedRMSE
    MaskedNormalizedRMSEResult = np.where(veg_type_arryay == 15, np.nan, CurrentNormalizedRMSEResult)

    CurrentAbsMeanResult = diff2_rmseDF.AbsMeanOFDiff
    MaskedAbsMeanResult = np.where(veg_type_arryay == 15, np.nan, CurrentAbsMeanResult)

    print("RMSE=", np.nanmean(MaskedRMSEResult))
    print("Mean=", np.nanmean(MaskedMeanResult))
    print("ABsMean=",np.nanmean(MaskedAbsMeanResult))


SpatialPath = "/scratch1/NCEPDEV/da/Azadeh.Gholoubi/control_env/static/ufs-land_C96_static_fields.nc"

# VarList=["snwdph","smc","weasd","stc","hflx","evap","gflux"]
VarList=["snwdph"]
for var in VarList:
    Computediff(var)
