import netCDF4
import matplotlib.pyplot as plt
import cartopy.feature as cfeature
import numpy as np
import pandas as pd
import cartopy.crs as ccrs
import os
from datetime import datetime
from datetime import timedelta

def ReadNETCDF(FilePath, GroupName, VariName):
    f = netCDF4.Dataset(FilePath)
    MyArray = f.groups[GroupName].variables[VariName][:]
    return MyArray

HofxPath="/scratch2/NCEPDEV/land/Youlong.Xia/landDA/cycle_land/DA_era5/DA/hofx"
PlotPath="/scratch2/NCEPDEV/land/Youlong.Xia/landDA/cycle_land/DA_era5/DA/plots/oman_snap/"
for i in range(0,6):
    HofxFile=HofxPath+"/letkf_hofx_ghcn_2019121518_000%d.nc"%i
    print(HofxFile)
    ombg_array = ReadNETCDF(HofxFile ,"oman","totalSnowDepth")
    latitude_array = ReadNETCDF(HofxFile ,"MetaData", "latitude")
    longitude_array=ReadNETCDF(HofxFile ,"MetaData", "longitude")
    print(i, ombg_array.size, ombg_array.shape, ombg_array.ndim)
    maxvalue = ombg_array.max()
    minvalue = ombg_array.min()
    fig = plt.figure(figsize=(12, 8))
    ax = fig.add_subplot(1, 1, 1, projection=ccrs.PlateCarree(central_longitude=0))
    ax.add_feature(cfeature.GSHHSFeature(scale='auto'))
    cs = plt.scatter(x=longitude_array, y=latitude_array, c=ombg_array, cmap="bwr", marker=',', s=10, vmax=300,
                     vmin=-300, transform=ccrs.PlateCarree())
    cb = plt.colorbar(cs, orientation='horizontal', shrink=0.5, pad=.04)
    cb.set_label("oman", fontsize=12)
    plt.title("Max=%s Min=%s" % (maxvalue, minvalue), fontsize=12)
    plt.savefig(os.path.join(PlotPath, "oman%d.png"%i))
    plt.close()
