****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

say 'Opening basin mask'
* Colorado River Basin
'sdfopen /scratch4/NCEPDEV/land/data/evaluation/basins/prototype/GRDC_prototype.nc'
'define mask1=maskout(basins,2401-basins)'
'define mask21=maskout(mask1,mask1-2401)'
'define mask2=maskout(basins,2106-basins)'
'define mask22=maskout(mask2,mask2-2106)'
'close 1'

say 'Opening control gdas snow data'
'open control_00z_oct24-mar2025_6hourly.ctl'
'set lon 0'
'set lat -90'
'set t 1 696'
'define csw11=tloop(aave(maskout(weasdsfc,mask21),lon=0,lon=360,lat=-90,lat=90))'
'define csd11=1000*tloop(aave(maskout(snodsfc,mask21),lon=0,lon=360,lat=-90,lat=90))'
'define csw12=tloop(aave(maskout(weasdsfc,mask22),lon=0,lon=360,lat=-90,lat=90))'
'define csd12=1000*tloop(aave(maskout(snodsfc,mask22),lon=0,lon=360,lat=-90,lat=90))'
'close 1'

say 'Opening snow2dvar gdas snow data'
'open snow2dvar_oct24-mar2025_6hourly.ctl'
'set lon 0'
'set lat -90'
'set t 1 696'
'define vsw11=tloop(aave(maskout(weasdsfc,mask21),lon=0,lon=360,lat=-90,lat=90))'
'define vsd11=1000*tloop(aave(maskout(snodsfc,mask21),lon=0,lon=360,lat=-90,lat=90))'
'define vsw12=tloop(aave(maskout(weasdsfc,mask22),lon=0,lon=360,lat=-90,lat=90))'
'define vsd12=1000*tloop(aave(maskout(snodsfc,mask22),lon=0,lon=360,lat=-90,lat=90))'
'close 1'

say 'Opening era5 snow data'
'open era5_grib2_grid_6hourly.ctl'
'set lon 0'
'set lat -90'
'set t 1 696'
'define sw21=1000*tloop(aave(maskout(swe,mask21),lon=0,lon=360,lat=-90,lat=90))'
'define sd21=tloop(aave(maskout((1000*swe/(snowdensity*0.001)),mask21),lon=0,lon=360,lat=-90,lat=90))'
'define sw22=1000*tloop(aave(maskout(swe,mask22),lon=0,lon=360,lat=-90,lat=90))'
'define sd22=tloop(aave(maskout((1000*swe/(snowdensity*0.001)),mask22),lon=0,lon=360,lat=-90,lat=90))'

*** PLOT daily time series
'page 4 1'
'set t 1 696'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 0 80'
'set ylint 20'
'set cthick 6'
'set cstyle 1'
'set ccolor 1'
'set cmark 0'
'd sw21'
'set cthick 6'
'set cstyle 1'
'set ccolor 4'
'set cmark 0'
'd csw11'
'set cthick 6'
'set cstyle 1'
'set ccolor 2'
'set cmark 0'
'd vsw11'

'draw ylab Snow Water Equivalent (mm)' 
'draw title (a) Armur River Basin'

'set strsiz .15'
'set line '1' '1' 5'
'draw line 2.8 7.2 3.3 7.2'
'set string '1' l 6 0'
'draw string 3.4 7.2 era5'

'set line '4' '1' 5'
'draw line 2.8 6.9 3.3 6.9'
'set string '4' l 6 0'
'draw string 3.4 6.9 control'

'set line '2' '1' 5'
'draw line 2.8 6.6 3.3 6.6'
'set string '2' l 6 0'
'draw string 3.4 6.6 snow2dvar'


'page 4 2'
'set t 1 696'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 0 200'
'set ylint 50'
'set cthick 6'
'set cstyle 1'
'set ccolor 1'
'set cmark 0'
'd sw22'
'set cthick 6'
'set cstyle 1'
'set ccolor 4'
'set cmark 0'
'd csw12'
'set cthick 6'
'set cstyle 1'
'set ccolor 2'
'set cmark 0'
'd vsw12'

'draw ylab Snow Water Equivalent (mm)'
'draw title (b) Lena River Basin'

'page 4 3'
'set t 1 696'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 0 320'
'set ylint 80'
'set cthick 6'
'set cstyle 1'
'set ccolor 1'
'set cmark 0'
'd sd21'
'set cthick 6'
'set cstyle 1'
'set ccolor 4'
'set cmark 0'
'd csd11'
'set cthick 6'
'set cstyle 1'
'set ccolor 2'
'set cmark 0'
'd vsd11'

'draw ylab Snow Depth (mm)'
'draw title (c) Armur River Basin'

'page 4 4'
'set t 1 696'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 0 600'
'set ylint 150'
'set cthick 6'
'set cstyle 1'
'set ccolor 1'
'set cmark 0'
'd sd22'
'set cthick 6'
'set cstyle 1'
'set ccolor 4'
'set cmark 0'
'd csd12'
'set cthick 6'
'set cstyle 1'
'set ccolor 2'
'set cmark 0'
'd vsd12'

'draw ylab Snow Depth (mm)'
'draw title (d) Lena River Basin'

'gxprint Armur_SWE_snowDepth_timeseries_6hourly_1Oct24-28Dec2025.png white x1100 y850'
*'quit'
