****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

say 'Opening basin mask'
* Colorado River Basin
'sdfopen /scratch2/NCEPDEV/land/data/evaluation/basins/prototype/GRDC_prototype.nc'
'define mask1=maskout(basins,4405-basins)'
'define mask21=maskout(mask1,mask1-4405)'
'close 1'

say 'Opening era5_land snow data'
'open era5_land_processed_ufsGrid.ctl'
'set t 1 334'
'define swand=maskout(swe,swe)'
'define sdland=maskout(snod,snod)'
'close 1'

say 'Opening era5_land snow data'
'open era5_land_processed_ufsGrid.ctl'
'set lon 0'
'set lat -90'
'set t 1 334'
'define sw3=1000*tloop(aave(maskout(maskout(swe,swand),mask21),lon=0,lon=360,lat=-90,lat=90))'
'define sd3=1000*tloop(aave(maskout(maskout(snod,sdland),mask21),lon=0,lon=360,lat=-90,lat=90))'
'close 1'

say 'Opening crocus_era5 snow data'
'open Crocus_era5_processed_ufsGrid.ctl'
'set lon 0'
'set lat -90'
'set t 1 334'
'define sw1=tloop(aave(maskout(maskout(swe,swand),mask21),lon=0,lon=360,lat=-90,lat=90))'
'define sd1=1000*tloop(aave(maskout(maskout(snod,sdland),mask21),lon=0,lon=360,lat=-90,lat=90))'

*** PLOT daily time series
'page 2 1'
'set t 1 334'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 0 80'
'set ylint 20'
'set cthick 6'
'set cstyle 1'
'set ccolor 1'
'set cmark 0'
'd sw1'
'set cthick 6'
'set cstyle 1'
'set ccolor 3'
'set cmark 0'
'd sw3'

'draw xlab Day'
'draw ylab Snow Water Equivalent (mm)' 
'draw title (a) Colorado River Basin'

'set strsiz .15'
'set line '1' '1' 5'
'draw line 2.8 7.5 3.3 7.5'
'set string '1' l 6 0'
'draw string 3.4 7.5 crocus_era5'

'set strsiz .15'
'set line '3' '1' 5'
'draw line 2.8 6.9 3.3 6.9'
'set string '3' l 6 0'
'draw string 3.4 6.9 era5_land'

'gxprint test.png white x1100 y850'
*'quit'
