****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

say 'Opening era5 t2m data'
'open era5t2m_grib2_grid.ctl'
'set t 1 92'
'define tera5=t2m'
'close 1'

say 'Opening control gdas snow data'
'open control_00z_oct-dec2024.ctl'
'set t 1'
'define RMSEt11=ave((tmp2m-tera5)*(tmp2m-tera5),t=1,t=92)'
'close 1'

say 'Opening snow2dvar gdas snow data'
'open snow2dvar_oct-dec_2024.ctl'
'set t 1'
'define RMSEt21=ave((tmp2m-tera5)*(tmp2m-tera5),t=1,t=92)'
'define st3=sqrt(RMSEt21)-sqrt(RMSEt11)'

*** PLOT spatial map

'page 1 1'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 0 360'
'set lat 0 90'
'set ylint 30'
'set xlint 60'
'set clevs -2.0 -1.5 -1.0 -0.5 -0.1 0.1 0.5 1.0 1.5 2.0'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd st3'
'cbarn'
'draw title 1Oct-31Dec24 t2m RMSE Difference (K) - refer to ERA5'

'gxprint globa_t2m_RMSE_Difference_Oct-Dec2024.png white x1100 y850'
*'quit'
