****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

say 'Opening era5 snow data'
'open era5_grib2_grid.ctl'
'set t 1'
'define sw21=1000*ave(maskout(swe,swe),t=1,t=175)'
'define sd21=ave(maskout((1000*swe/(snowdensity*0.001)),swe),t=1,t=175)'
'close 1'

say 'Opening control gdas snow data'
'open control_00z_oct2024-mar2025.ctl'
'set t 1'
'define csw11=ave(maskout(weasdsfc,weasdsfc),t=1, t=175)'
'define csd11=1000*ave(maskout(snodsfc,snodsfc),t=1, t=175)'

'define RMSEswe12=ave((weasdsfc-sw21)*(weasdsfc-sw21),t=1, t=175)'
'define RMSEsnod12=ave((1000*snodsfc-sd21)*(1000*snodsfc-sd21),t=1, t=175)'
'close 1'

say 'Opening snow2dvar gdas snow data'
'open snow2dvar_oct2024-mar2025.ctl'
'set t 1'
'define vsw11=ave(maskout(weasdsfc,weasdsfc),t=1,t=175)'
'define vsd11=1000*ave(maskout(snodsfc,snodsfc),t=1,t=175)'

'define RMSEswe22=ave((weasdsfc-sw21)*(weasdsfc-sw21),t=1, t=175)'
'define RMSEsnod22=ave((1000*snodsfc-sd21)*(1000*snodsfc-sd21),t=1,t=175)'

* calculate bias between control and ERA5, snow2davr and ERA5
'set t 1'
'define sd1=csd11-sd21'
'define sd2=vsd11-sd21'

'define sd3=100*(sqrt(RMSEsnod22)-sqrt(RMSEsnod12))/(sqrt(RMSEsnod12)+0.1)'
'define sd4=100*(sqrt(RMSEswe22)-sqrt(RMSEswe12))/(sqrt(RMSEswe12)+0.1)'


*** PLOT spatial map

'page 2 1'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 0 360'
'set lat 0 90'
'set ylint 30'
'set xlint 60'
'set clevs -90 -70 -50 -30 -10 10 30 50 70 90'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sd1'
'cbarn'
'draw title (a) Control-ERA5 Snow Depth (mm)'

'page 2 2'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 0 360'
'set lat 0 90'
'set ylint 30'
'set xlint 60'
'set clevs -90 -70 -50 -30 -10 10 30 50 70 90'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sd2'
'cbarn'
'draw title (b) 2dvar-ERA5 Snow Depth (mm)'


'gxprint globa_Bias_SnowDepth_1Oct24-28Mar2025.png white x1100 y850'
*'quit'
