****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

say 'Opening control gdas snow data'
'open controlGDAS.ctl'
'set t 1'
'define csw11=ave(maskout(weasdsfc,weasdsfc),t=1, t=122)'
'define csd11=1000*ave(maskout(snodsfc,snodsfc),t=1, t=122)'
'close 1'

say 'Opening snow2dvar gdas snow data'
'open snow2dvar.ctl'
'set t 1'
'define vsw11=ave(maskout(weasdsfc,weasdsfc),t=1, t=122)'
'define vsd11=1000*ave(maskout(snodsfc,snodsfc),t=1,t=122)'
'close 1'

say 'Opening crocus_era5 snow data'
'open Crocus_era5_processed_ufsGrid.ctl'
'set t 1'
'define sw11=ave(maskout(swe,swe),t=1,t=122)'
'define sd11=1000*ave(maskout(snod,snod),t=1,t=122)'
'close 1'

say 'Opening era5 snow data'
'open era5_processed_ufsGrid.ctl'
'set t 1'
'define sw21=1000*ave(maskout(swe,swe),t=1,t=122)'
'define sd21=ave(maskout((1000*swe/(snowdensity*0.001)),swe),t=1,t=122)'

'set t 1'
'define sd1=csd11-sd11'
'define sd2=vsd11-sd11'
'define sd3=csd11-sd21'
'define sd4=vsd11-sd21'

*** PLOT spatial map

'page 4 1'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 0 360'
'set lat 0 90'
'set ylint 30'
'set xlint 60'
'set clevs -90 -70 -50 -30 -10 10 30 50 70 90'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sd1'
'cbarn'
'draw title (a) Control-Crocus snow depth (mm)'

'page 4 2'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 0 360'
'set lat 0 90'
'set ylint 30'
'set xlint 60'
'set clevs -90 -70 -50 -30 -10  10 30 50 70 90'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sd2'
'cbarn'
'draw title (b) snow2dvar-Crocus snow depth (mm)'

'page 4 3'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 0 360'
'set lat 0 90'
'set ylint 30'
'set xlint 60'
'set clevs -90 -70 -50 -30 -10 10 30 50 70 90'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sd3'
'cbarn'
'draw title (c) Control-ERA5 snow depth (mm)'

'page 4 4'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 0 360'
'set lat 0 90'
'set ylint 30'
'set xlint 60'
'set clevs -90 -70 -50 -30 -10  10 30 50 70 90'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sd4'
'cbarn'
'draw title (d) snow2dvar-ERA5 snow depth (mm)'


'gxprint globa_Bias_SnowDepth_referTo_SNODAS_UA.png white x1100 y850'
*'quit'
