****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

say 'Opening era5 snow data'
'open era5_grib2_grid.ctl'
'set t 1 175'
'define sw21=1000*swe'
'define sd21=1000*swe/(snowdensity*0.001)'
'close 1'

say 'Opening control gdas snow data'
'open control_00z_oct2024-mar2025.ctl'
'set t 1'
'define RMSEswe12=ave((weasdsfc-sw21)*(weasdsfc-sw21),t=1, t=175)*sqrt(175.0)'
'define RMSEsnod12=ave((1000*snodsfc-sd21)*(1000*snodsfc-sd21),t=1, t=175)*sqrt(175.0)'

'define BIASswe12=ave((weasdsfc-sw21),t=1, t=175)'
'define BIASsnod12=ave((1000*snodsfc-sd21),t=1, t=175)'

'close 1'

say 'Opening snow2dvar gdas snow data'
'open snow2dvar_oct2024-mar2025.ctl'
'set t 1'
'define RMSEswe22=ave((weasdsfc-sw21)*(weasdsfc-sw21),t=1, t=175)*sqrt(175.0)'
'define RMSEsnod22=ave((1000*snodsfc-sd21)*(1000*snodsfc-sd21),t=1,t=175)*sqrt(175.0)'

'define BIASswe22=ave((weasdsfc-sw21),t=1, t=175)'
'define BIASsnod22=ave((1000*snodsfc-sd21),t=1,t=175)'

'set t 1'

'define sd2=sqrt(RMSEswe22-BIASswe22*BIASswe22)-sqrt(RMSEswe12-BIASswe12*BIASswe12)'
'define sd4=sqrt(RMSEsnod22-BIASsnod22*BIASsnod22)-sqrt(RMSEsnod12-BIASsnod12*BIASsnod12)'

*** PLOT spatial map

'page 2 1'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 0 360'
'set lat 0 90'
'set ylint 30'
'set xlint 60'
'set clevs -9 -7 -5 -3 -1 1 3 5 7 9'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sd2'
'cbarn'
'draw title (a)SWE ubRMSE Difference (mm) - refer to era5'

'page 2 2'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 0 360'
'set lat 0 90'
'set ylint 30'
'set xlint 60'
'set clevs -45 -35 -25 -15 -5 5 15 25 35 45'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sd4'
'cbarn'
'draw title (b) SNOD ubRMSE Difference (mm) - refer to ERA5'


'gxprint global_ubRMSE_Difference_ERA5_1Oct24-28MarDec2025_00Z.png white x1100 y850'
*'quit'
