****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

say 'Opening era5 snow data'
'open era5_grib2_grid.ctl'
'set t 1'
'define sw21=1000*ave(maskout(swe,swe),t=1,t=92)'
'define sd21=ave(maskout((1000*swe/(snowdensity*0.001)),swe),t=1,t=92)'
'close 1'

say 'Opening control gdas snow data'
'open control_00z_oct-dec2024.ctl'
'set t 1'
'define csw11=ave(maskout(weasdsfc,weasdsfc),t=1, t=92)'
'define csd11=1000*ave(maskout(snodsfc,snodsfc),t=1, t=92)'

'define RMSEswe12=ave((weasdsfc-sw21)*(weasdsfc-sw21),t=1, t=92)'
'define RMSEsnod12=ave((1000*snodsfc-sd21)*(1000*snodsfc-sd21),t=1, t=92)'
'close 1'

say 'Opening snow2dvar gdas snow data'
'open snow2dvar_oct-dec_2024.ctl'
'set t 1'
'define vsw11=ave(maskout(weasdsfc,weasdsfc),t=1,t=92)'
'define vsd11=1000*ave(maskout(snodsfc,snodsfc),t=1,t=92)'

'define RMSEswe22=ave((weasdsfc-sw21)*(weasdsfc-sw21),t=1, t=92)'
'define RMSEsnod22=ave((1000*snodsfc-sd21)*(1000*snodsfc-sd21),t=1,t=92)'

* calculate bias between control and ERA5, snow2davr and ERA5
'set t 1'
'define sd1=csd11-sd21'
'define sd2=vsd11-sd21'

'define sd3=100*(sqrt(RMSEsnod22)-sqrt(RMSEsnod12))/(sqrt(RMSEsnod12)+0.1)'
'define sd4=100*(sqrt(RMSEswe22)-sqrt(RMSEswe12))/(sqrt(RMSEswe12)+0.1)'


*** PLOT spatial map

'page 4 1'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 260 275'
'set lat 40 46'
'set ylint 1'
'set xlint 3'
'set clevs -90 -70 -50 -30 -10 10 30 50 70 90'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sd1'
'cbarn'
'draw title (a) Control-ERA5 Snow Depth (mm)'

'page 4 2'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 260 275'
'set lat 40 46'
'set ylint 1'
'set xlint 3'
'set clevs -90 -70 -50 -30 -10  10 30 50 70 90'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sd2'
'cbarn'
'draw title (b) snow2dvar-ERA5 Snow Depth (mm)'

'page 4 3'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 260 275'
'set lat 40 46'
'set ylint 1'
'set xlint 3'
'set clevs -90 -70 -50 -30 -10 10 30 50 70 90'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sd3'
'cbarn'
'draw title (c) SNOD RMSE Difference Percentage (%) - Control'

'page 4 4'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 260 275'
'set lat 40 46'
'set ylint 1'
'set xlint 3'
'set clevs -90 -70 -50 -30 -10  10 30 50 70 90'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sd4'
'cbarn'
'draw title (d) SWE RMSE Difference Percentage (%) - snow2davr'


'gxprint GreatLake_Bias_RMSE_difference_percent_SnowDepth_Oct-Dec2024.png white x1100 y850'
*'quit'
