****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'


say 'Opening control gdas snow data'
'open control_00z_oct-dec2024.ctl'
'set lon 268'
'set lat 41'
'set t 1 92'
'define csw11=tloop(aave(weasdsfc,lon=268,lon=272,lat=41,lat=43))'
'define csd11=1000*tloop(aave(snodsfc,lon=268,lon=272,lat=41,lat=43))'
'close 1'

say 'Opening snow2dvar gdas snow data'
'open snow2dvar_oct-dec_2024.ctl'
'set lon 268'
'set lat 41'
'set t 1 92'
'define vsw11=tloop(aave(weasdsfc,lon=268,lon=272,lat=41,lat=43))'
'define vsd11=1000*tloop(aave(snodsfc,lon=268,lon=272,lat=41,lat=43))'
'close 1'

say 'Opening era5 snow data'
'open era5_grib2_grid.ctl'
'set lon 268'
'set lat 41'
'set t 1 92'
'define sw11=1000*tloop(aave(swe,lon=268,lon=272,lat=41,lat=43))'
'define sd11=tloop(aave(1000*swe/(snowdensity*0.001),lon=268,lon=272,lat=41,lat=43))'

*** PLOT daily time series
'page 2 1'
'set t 1 92'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 0 100'
'set ylint 20'
'set xlabs 01Oct|15Oct|30Oct|14Nov|29Nov|14Dec|31Dec'
'set cthick 6'
'set cstyle 1'
'set ccolor 1'
'set cmark 0'
'd sd11'
'set cthick 6'
'set cstyle 1'
'set ccolor 4'
'set cmark 0'
'd csd11'
'set cthick 6'
'set cstyle 1'
'set ccolor 2'
'set cmark 0'
'd vsd11'

'draw xlab Day'
'draw ylab Snow Depth (mm)' 
'draw title (a) Great Lake Region (88-92W,41-43N)'


'page 2 2'
'set t 1 92'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 0 20'
'set ylint 5'
'set xlabs 01Oct|15Oct|30Oct|14Nov|29Nov|14Dec|31Dec'
'set cthick 6'
'set cstyle 1'
'set ccolor 1'
'set cmark 0'
'd sw11'
'set cthick 6'
'set cstyle 1'
'set ccolor 4'
'set cmark 0'
'd csw11'
'set cthick 6'
'set cstyle 1'
'set ccolor 2'
'set cmark 0'
'd vsw11'

'draw xlab Day'
'draw ylab Snow Water Equivalent (mm)'
'draw title (b) Great Lake Region (88-92W,41-43N)'

'gxprint GreatLake_SWE_snowDepth_timeseries_1Oct-31Dec2024_00Z.png white x1100 y850'
*'quit'
