****** Verify crocus_era5, era5, era5-land, snodas, ua, **********
****** as well as coupled snow DA experiments for snow data ******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

say 'Opening crocus_era5 snow data'
'open Crocus_era5_processed_ufsGrid.ctl'
'set lat 45'
'set lon 250'
'set t 1 334'
'define swater1=maskout(swe,swe)'
'define sdepth1=1000*maskout(snod,snod)'
'close 1'

say 'Opening era5 snow data'
'open era5_processed_ufsGrid.ctl'
'set lat 45'
'set lon 250'
'set t 1 334'
'define swater2=1000*maskout(swe,swe)'
'define sdnesity=maskout(snowdensity,snowdensity)'
'define sdepth2=swater2/(sdnesity*0.001)'
'close 1'

say 'Opening era5_land snow data'
'open era5_land_processed_ufsGrid.ctl'
'set lat 45'
'set lon 250'
'set t 1 334'
'define swater3=1000*maskout(swe,swe)'
'define sdepth3=1000*maskout(snod,snod)'
'close 1'

say 'OPENING snodas snow data'
'open snodas_processed_ufsGrid.ctl'
'set lat 45'
'set lon 250'
'set t 1 334'
'define swater4=maskout(swe,swe)'
'define sdepth4=maskout(snod,snod)'
'close 1'

say 'OPENING ua snow data'
'open ua_processed_ufsGrid.ctl'
'set lat 45'
'set lon 250'
'set t 1 334'
'define swater5=maskout(swe,swe)'
'define sdepth5=maskout(snod,snod)'

*** PLOT SWE/snow depth time series for grid point {45oN, 250] ***
'set t 1 334'
'set gxout line'
'set grid off'
'set grads off'
'set vrange 0 2400'
'set ylint 400'
*'set xlabs 01JUL|5JUL|10JUL|15JUL|20JUL|25JUL|31JUL'
'set cthick 6'
'set cstyle 1'
'set ccolor 1'
'set cmark 0'
'd sdepth1'
'set cthick 6'
'set cstyle 1'
'set ccolor 2'
'set cmark 0'
'd sdepth2'
'set cthick 6'
'set cstyle 1'
'set ccolor 3'
'set cmark 0'
'd sdepth3'
'set cthick 6'
'set cstyle 1'
'set ccolor 4'
'set cmark 0'
'd sdepth4'
'set cthick 6'
'set cstyle 1'
'set ccolor 8'
'set cmark 0'
'd sdepth5'

'draw xlab Day'
'draw ylab Snow Depth (mm)' 
'draw title grid point [45oN, -110oW]'

'set strsiz .15'
'set line '1' '1' 5'
'draw line 2.8 7.5 3.3 7.5'
'set string '1' l 6 0'
'draw string 3.4 7.5 crocus_era5'

'set strsiz .15'
'set line '2' '1' 5'
'draw line 2.8 7.2 3.3 7.2'
'set string '2' l 6 0'
'draw string 3.4 7.2 era5'

'set strsiz .15'
'set line '3' '1' 5'
'draw line 2.8 6.9 3.3 6.9'
'set string '3' l 6 0'
'draw string 3.4 6.9 era5_land'

'set line '4' '1' 5'
'draw line 2.8 6.6 3.3 6.6'
'set string '4' l 6 0'
'draw string 3.4 6.6 snodas'

'set line '8' '1' 5'
'draw line 2.8 6.3 3.3 6.3'
'set string '8' l 6 0'
'draw string 3.4 6.3 ua'

'gxprint One_US_point_snowDepth_timeseries.png white x1100 y850'
'quit'
