****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

say 'Opening era5 t2m data'
'open era5t2m_grib2_grid.ctl'
'set t 1 61'
'define tera5=t2m'
'close 1'

say 'Opening control gdas snow data'
'open control_00z_AprToMay.ctl'
'set t 1'
'define RMSEt11=ave((tmp2m-tera5)*(tmp2m-tera5),t=1,t=61)'
'close 1'

say 'Opening snow2dvar gdas snow data'
'open snow2dvar_00z_AprToMay.ctl'
'set t 1'
'define RMSEt21=ave((tmp2m-tera5)*(tmp2m-tera5),t=1,t=61)'
'define st3=sqrt(RMSEt21)-sqrt(RMSEt11)'
'close 1'

say 'Opening era5 t2m data'
'open era5t2m_grib2_grid_peak.ctl'
'set t 1 90'
'define tera5=t2m'
'close 1'

say 'Opening control gdas snow data'
'open control_00z_JanToMar.ctl'
'set t 1'
'define RMSEt11=ave((tmp2m-tera5)*(tmp2m-tera5),t=1,t=90)'
'close 1'

say 'Opening snow2dvar gdas snow data'
'open snow2dvar_00z_JanToMar.ctl'
'set t 1'
'define RMSEt21=ave((tmp2m-tera5)*(tmp2m-tera5),t=1,t=90)'
'define st2=sqrt(RMSEt21)-sqrt(RMSEt11)'
'close 1'

say 'Opening era5 t2m data'
'open era5t2m_grib2_grid_accumulation.ctl'
'set t 1 92'
'define tera5=t2m'
'close 1'

say 'Opening control gdas snow data'
'open control_00z_OctToDec21.ctl'
'set t 1'
'define RMSEt11=ave((tmp2m-tera5)*(tmp2m-tera5),t=1,t=92)'
'close 1'

say 'Opening snow2dvar gdas snow data'
'open snow2dvar_00z_OctToDec21.ctl'
'set t 1'
'define RMSEt21=ave((tmp2m-tera5)*(tmp2m-tera5),t=1,t=92)'
'define st1=sqrt(RMSEt21)-sqrt(RMSEt11)'

*** PLOT spatial map

'page 3 1'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 60 120'
'set lat 30 60'
'set ylint 10'
'set xlint 20'
'set clevs -2.0 -1.5 -1.0 -0.5 -0.1 0.1 0.5 1.0 1.5 2.0'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd st1'
'cbarn'
'draw title (a) 1Oct-31Dec21 t2m RMSE Difference (K) - refer to ERA5'

'page 3 2'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 60 120'
'set lat 30 60'
'set ylint 10'
'set xlint 20'
'set clevs -2.0 -1.5 -1.0 -0.5 -0.1 0.1 0.5 1.0 1.5 2.0'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd st2'
'cbarn'
'draw title (b) 1Jan-31Mar22 t2m RMSE Difference (K) - refer to ERA5'

'page 3 3'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 60 120'
'set lat 30 60'
'set ylint 10'
'set xlint 20'
'set clevs  -2.0 -1.5 -1.0 -0.5 -0.1 0.1 0.5 1.0 1.5 2.0'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd st3'
'cbarn'
'draw title (c) 1Apr-31May22 t2m RMSE difference (K) - refer to ERA5'

'gxprint Tibetan_t2m_RMSE_Difference.png white x1100 y850'
*'quit'
