****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

say 'Opening control gdas snow data'
'open control_00z_AprToMay.ctl'
'set lon 250'
'set lat 60'
'set t 1 61'
'define csw11=tloop(aave(weasdsfc,lon=250,lon=270,lat=60,lat=70))'
'define csd11=1000*tloop(aave(snodsfc,lon=250,lon=270,lat=60,lat=70))'
'close 1'

say 'Opening snow2dvar gdas snow data'
'open snow2dvar_00z_AprToMay.ctl'
'set lon 250'
'set lat 60'
'set t 1 61'
'define vsw11=tloop(aave(weasdsfc,lon=250,lon=270,lat=60,lat=70))'
'define vsd11=1000*tloop(aave(snodsfc,lon=250,lon=270,lat=60,lat=70))'
'close 1'

say 'Opening crocus_era5 snow data'
'open Crocus_era5_processed_ufsGrid.ctl'
'set lon 250'
'set lat 60'
'set t 1 61'
'define sw11=tloop(aave(swe,lon=250,lon=270,lat=60,lat=70))'
'define sd11=1000*tloop(aave(snod,lon=250,lon=270,lat=60,lat=70))'
'close 1'

say 'Opening era5 snow data'
'open era5_processed_ufsGrid.ctl'
'set lon 250'
'set lat 60'
'set t 1 61'
'define sw21=1000*tloop(aave(swe,lon=250,lon=270,lat=60,lat=70))'
'define sd21=tloop(aave(1000*swe/(snowdensity*0.001),lon=250,lon=270,lat=60,lat=70))'

*** PLOT daily time series
'page 2 1'
'set t 1 61'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 0 300'
'set ylint 100'
'set xlabs 01A|10A|20A|30A|10M|20M|31M'
'set cthick 6'
'set cstyle 1'
'set ccolor 1'
'set cmark 0'
'd sw11'
'set cthick 6'
'set cstyle 1'
'set ccolor 2'
'set cmark 0'
'd sw21'
'set cthick 6'
'set cstyle 1'
'set ccolor 3'
'set cmark 0'
'd csw11'
'set cthick 6'
'set cstyle 1'
'set ccolor 9'
'set cmark 0'
'd vsw11'

'draw xlab Day'
'draw ylab Snow Water Equivalent (mm)' 
'draw title (a) North Canada'

'set strsiz .15'
'set line '1' '1' 5'
'draw line 2.8 7.5 3.3 7.5'
'set string '1' l 6 0'
'draw string 3.4 7.5 crocus_era5'

'set strsiz .15'
'set line '2' '1' 5'
'draw line 2.8 7.2 3.3 7.2'
'set string '2' l 6 0'
'draw string 3.4 7.2 era5'

'set line '3' '1' 5'
'draw line 2.8 6.9 3.3 6.9'
'set string '3' l 6 0'
'draw string 3.4 6.9 control'

'set line '9' '1' 5'
'draw line 2.8 6.6 3.3 6.6'
'set string '9' l 6 0'
'draw string 3.4 6.6 snow2dvar'


'page 2 2'
'set t 1 61'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 0 900'
'set ylint 300'
'set xlabs 01A|10A|20A|30A|10M|20M|31M'
'set cthick 6'
'set cstyle 1'
'set ccolor 1'
'set cmark 0'
'd sd11'
'set cthick 6'
'set cstyle 1'
'set ccolor 2'
'set cmark 0'
'd sd21'
'set cthick 6'
'set cstyle 1'
'set ccolor 3'
'set cmark 0'
'd csd11'
'set cthick 6'
'set cstyle 1'
'set ccolor 9'
'set cmark 0'
'd vsd11'

'draw xlab Day'
'draw ylab Snow Depth (mm)'
'draw title (b) North Canada'

'gxprint NorthEast_Canada_SWE_snowDepth_timeseries_1Apr-31May2022_00Z.png white x1100 y850'
*'quit'
