****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

* Great Salt lake Basin
'open river_basin_grib2_grid.ctl'
'define mask1=maskout(basins,4901-basins)'
'define mask21=maskout(mask1,mask1-4901)'
'close 1'

say 'Opening control gdas snow data'
'open control_00z_AprToMay.ctl'
'set t 1'
'define cswe=ave(weasdsfc,t=1, t=61)'
'define csnod=ave(1000*snodsfc,t=1, t=61)'
'close 1'

say 'Opening snow2dvar gdas snow data'
'open snow2dvar_00z_AprToMay.ctl'
'set t 1'
'define vswe=ave(weasdsfc,t=1, t=61)'
'define vsnod=ave(1000*snodsfc,t=1,t=61)'
'define veg=ave(vgtypsfc,t=1,t=61)'

'define cswe=maskout(cswe,mask21)'
'define csnod=maskout(csnod,mask21)'
'define vswe=maskout(vswe,mask21)'
'define vsnod=maskout(vsnod,mask21)'
'define veg=maskout(veg,mask21)'

*** PLOT spatial map

'page 2 1'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 245 250'
'set lat 37 43'
'set ylint 2'
'set xlint 1'
'set clevs -50 -30 -20 -10 -1 1 10 50 100 150'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd (vswe-cswe)'
'cbarn'
'draw title (a) SWE (mm) 2dvar-control'
'set gxout contour'
'set clevs 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16'
'd veg'


'page 2 2'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 245 250'
'set lat 37 43'
'set ylint 2'
'set xlint 1'
'set clevs -2000 -500 -300 -100 -10 10 100 300 500 2000'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd (vsnod-csnod)'
'cbarn'
'draw title (b) SNOD (mm) 2dvar-control'
'set gxout contour'
'set clevs 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16'
'd veg'


'gxprint GreatSaltLake_riverBasin_2dvar-control_1Apr-31May2022.png white x1100 y850'
*'quit'
