****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

* Great Salt lake Basin
'open river_basin_grib2_grid.ctl'
'define mask1=maskout(basins,4901-basins)'
'define mask21=maskout(mask1,mask1-4901)'
'close 1'

say 'Opening control gdas snow data'
'open control_00z_AprToMay.ctl'
'set t 1 61'
'define csd11=1000*maskout(snodsfc,snodsfc)'
'close 1'

say 'Opening snow2dvar gdas snow data'
'open snow2dvar_00z_AprToMay.ctl'
'set t 1 61'
'define vsd11=1000*maskout(snodsfc,snodsfc)'
'close 1'

say 'Opening crocus_era5 snow data'
'open Crocus_grib2_grid.ctl'
'set t 1 61'
'define sd11=1000*maskout(snod,snod)'
'close 1'

say 'Opening era5 snow data'
'open era5_grib2_grid.ctl'
'set t 1 61'
'define sd21=maskout((1000*swe/(snowdensity*0.001)),swe)'

** compute average values for a variable ********
'set t 1'
'define msd11=ave(sd11,t=1,t=61)'
'define msd21=ave(sd21,t=1,t=61)'
'define mcsd11=ave(csd11,t=1,t=61)'
'define mvsd11=ave(vsd11,t=1,t=61)'

*** calculate (A-Am)*(B-Bm) ********************************
'define csdsd11=ave((csd11-mcsd11)*(sd11-msd11),t=1,t=61)'
'define csdsd21=ave((csd11-mcsd11)*(sd21-msd21),t=1,t=61)'
'define vsdsd11=ave((vsd11-mvsd11)*(sd11-msd11),t=1,t=61)'
'define vsdsd21=ave((vsd11-mvsd11)*(sd21-msd21),t=1,t=61)'

**** calculate (X-Xm)*(X-Xm) for these variables ************
'define sqCrocus=ave((sd11-msd11)*(sd11-msd11),t=1,t=61)'
'define sqERA5=ave((sd21-msd21)*(sd21-msd21),t=1,t=61)'
'define snow2dvar=ave((vsd11-mvsd11)*(vsd11-mvsd11),t=1,t=61)'
'define control=ave((csd11-mcsd11)*(csd11-mcsd11),t=1,t=61)'

*** calculate correlation between two varaibles ************
'define rcc=csdsd11/sqrt(sqCrocus*control)'
'define rce=csdsd21/sqrt(sqERA5*control)'
'define rsc=vsdsd11/sqrt(sqCrocus*snow2dvar)'
'define rse=vsdsd21/sqrt(sqERA5*snow2dvar)'

'define rcc=maskout(rcc,mask21)'
'define rce=maskout(rce,mask21)'
'define rsc=maskout(rsc,mask21)'
'define rse=maskout(rse,mask21)'

*** PLOT spatial map

'page 4 1'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 245 250'
'set lat 37 43'
'set ylint 2'
'set xlint 1'
'set clevs 0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9'
'set ccols 0 14 4 11 5 13 7 12 8 2 6'
'd rsc'
'cbarn'
'draw title (a) Correlation between snow2dvar and Crocus'

'page 4 2'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 245 250'
'set lat 37 43'
'set ylint 2'
'set xlint 1'
'set clevs 0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9'
'set ccols 0 14 4 11 5 13 7 12 8 2 6'
'd rse'
'cbarn'
'draw title (b) Correlation between snow2dvar and ERA5'

'page 4 3'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 245 250'
'set lat 37 43'
'set ylint 2'
'set xlint 1'
'set clevs -0.25 -0.2 -0.15 -0.1 -0.05 0.05 0.1 0.15 0.2 0.25'
'set ccols 14 4 11 5 13 0 7 12 8 2 6'
'd (rsc-rcc)'
'cbarn'
'draw title (c) Correlation snow2dvar-control: Refer to Crocus'

'page 4 4'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 245 250'
'set lat 37 43'
'set ylint 2'
'set xlint 1'
'set clevs -0.25 -0.2 -0.15 -0.1 -0.05 0.05 0.1 0.15 0.2 0.25'
'set ccols 14 4 11 5 13 0 7 12 8 2 6'
'd (rse-rce)'
'cbarn'
'draw title (d) Correlation snow2dvar-control: refer to ERA5'


'gxprint SaltLake_correlation_snowDepth_1Apr-31May2022_00Z.png white x1100 y850'
*'quit'
