****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

* Great Salt lake Basin
'open river_basin_grib2_grid.ctl'
'define mask1=maskout(basins,4901-basins)'
'define mask21=maskout(mask1,mask1-4901)'
'close 1'

say 'Opening crocus_era5 snow data'
'open Crocus_grib2_grid.ctl'
'set t 1 61'
'define sw11=swe'
'define sd11=1000*snod'
'close 1'

say 'Opening era5 snow data'
'open era5_grib2_grid.ctl'
'set t 1 61'
'define sw21=1000*swe'
'define sd21=1000*swe/(snowdensity*0.001)'
'close 1'

say 'Opening control gdas snow data'
'open control_00z_AprToMay.ctl'
'set t 1'
'define RMSEswe11=ave((weasdsfc-sw11)*(weasdsfc-sw11),t=1, t=61)'
'define RMSEsnod11=ave((1000*snodsfc-sd11)*(1000*snodsfc-sd11),t=1, t=61)'
'define RMSEswe12=ave((weasdsfc-sw21)*(weasdsfc-sw21),t=1, t=61)'
'define RMSEsnod12=ave((1000*snodsfc-sd21)*(1000*snodsfc-sd21),t=1, t=61)'
'close 1'

say 'Opening snow2dvar gdas snow data'
'open snow2dvar_00z_AprToMay.ctl'
'set t 1'
'define RMSEswe21=ave((weasdsfc-sw11)*(weasdsfc-sw11),t=1, t=61)'
'define RMSEsnod21=ave((1000*snodsfc-sd11)*(1000*snodsfc-sd11),t=1,t=61)'
'define RMSEswe22=ave((weasdsfc-sw21)*(weasdsfc-sw21),t=1, t=61)'
'define RMSEsnod22=ave((1000*snodsfc-sd21)*(1000*snodsfc-sd21),t=1,t=61)'

'set t 1'
'define sd1=100*(sqrt(RMSEswe21)-sqrt(RMSEswe11))/sqrt(RMSEswe11)'
'define sd2=100*(sqrt(RMSEsnod21)-sqrt(RMSEsnod11))/sqrt(RMSEsnod11)'
'define sd3=100*(sqrt(RMSEswe22)-sqrt(RMSEswe12))/sqrt(RMSEswe12)'
'define sd4=100*(sqrt(RMSEsnod22)-sqrt(RMSEsnod12))/sqrt(RMSEsnod12)'

'define sd1=maskout(sd1,mask21)'
'define sd2=maskout(sd2,mask21)'
'define sd3=maskout(sd3,mask21)'
'define sd4=maskout(sd4,mask21)'

*** PLOT spatial map

'page 4 1'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 245 250'
'set lat 37 43'
'set ylint 2'
'set xlint 1'
'set clevs -50 -30 -20 -10 -1 1 10 20 30 50'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sd1'
'cbarn'
'draw title (a) SWE RMSE Difference Percentage (%) - refer to Crocus'

'page 4 2'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 245 250'
'set lat 37 43'
'set ylint 2'
'set xlint 1'
'set clevs -50 -30 -20 -10 -1 1 10 20 30 50'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sd2'
'cbarn'
'draw title (b) SNOD RMSE Difference Percentage (%) - refer to Crocus'

'page 4 3'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 245 250'
'set lat 37 43'
'set ylint 2'
'set xlint 1'
'set clevs -50 -30 -20 -10 -1 1 10 20 30 50'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sd3'
'cbarn'
'draw title (c) SWE RMSE difference Percentage (%) - refer to ERA5'

'page 4 4'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 245 250'
'set lat 37 43'
'set ylint 2'
'set xlint 1'
'set clevs -50 -30 -20 -10 -1 1 10 20 30 50'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sd4'
'cbarn'
'draw title (d) SNOD RMSE Difference Percentage (%) - refer to ERA5'

'gxprint GreatSaltLake_riverBasin_RMSE_Difference_Crocus_ERA5_1Apr-31May2022.png white x1100 y850'
*'quit'
