****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

say 'Opening control gdas snow data'
'open controlGDAS.ctl'
'set t 1 122'
'define csd11=1000*maskout(snodsfc,snodsfc)'
'close 1'

say 'Opening snow2dvar gdas snow data'
'open snow2dvar.ctl'
'set t 1 122'
'define vsd11=1000*maskout(snodsfc,snodsfc)'
'close 1'

say 'Opening crocus_era5 snow data'
'open Crocus_grib2_grid.ctl'
'set t 1 122'
'define sd11=1000*maskout(snod,snod)'
'close 1'

say 'Opening era5 snow data'
'open era5_grib2_grid.ctl'
'set t 1 122'
'define sd21=maskout((1000*swe/(snowdensity*0.001)),swe)'

** compute average values for a variable ********
'set t 1'
'define msd11=ave(sd11,t=1,t=122)'
'define msd21=ave(sd21,t=1,t=122)'
'define mcsd11=ave(csd11,t=1,t=122)'
'define mvsd11=ave(vsd11,t=1,t=122)'

*** calculate (A-Am)*(B-Bm) ********************************
'define csdsd11=ave((csd11-mcsd11)*(sd11-msd11),t=1,t=122)'
'define csdsd21=ave((csd11-mcsd11)*(sd21-msd21),t=1,t=122)'
'define vsdsd11=ave((vsd11-mvsd11)*(sd11-msd11),t=1,t=122)'
'define vsdsd21=ave((vsd11-mvsd11)*(sd21-msd21),t=1,t=122)'

**** calculate (X-Xm)*(X-Xm) for these variables ************
'define sqCrocus=ave((sd11-msd11)*(sd11-msd11),t=1,t=122)'
'define sqERA5=ave((sd21-msd21)*(sd21-msd21),t=1,t=12)'
'define snow2dvar=ave((vsd11-mvsd11)*(vsd11-mvsd11),t=1,t=122)'
'define control=ave((csd11-mcsd11)*(csd11-mcsd11),t=1,t=122)'

*** calculate correlation between two variabes ************
'define rcc=csdsd11/sqrt(sqCrocus*control)'
'define rce=csdsd21/sqrt(sqERA5*control)'
'define rsc=vsdsd11/sqrt(sqCrocus*snow2dvar)'
'define rse=vsdsd21/sqrt(sqERA5*snow2dvar)'

*** calclate normalized sigma f ************************
'define sigmaf1=sqrt(control)/sqrt(sqCrocus)'
'define sigmaf2=sqrt(control)/sqrt(sqERA5)'
'define sigmaf3=sqrt(snow2dvar)/sqrt(sqCrocus)'
'define sigmaf4=sqrt(snow2dvar)/sqrt(sqERA5)'

'define t1=(0.25*(1.0+rsc)*(1.0+rsc)*(1.0+rsc)*(1.0+rsc))/((sigmaf3+1.0/sigmaf3)*(sigmaf3+1.0/sigmaf3))'
'define t2=(0.25*(1.0+rse)*(1.0+rse)*(1.0+rse)*(1.0+rse))/((sigmaf4+1.0/sigmaf4)*(sigmaf4+1.0/sigmaf4))'
'define t3=(0.25*(1.0+rcc)*(1.0+rcc)*(1.0+rcc)*(1.0+rcc))/((sigmaf1+1.0/sigmaf1)*(sigmaf1+1.0/sigmaf1))'
'define t4=(0.25*(1.0+rce)*(1.0+rce)*(1.0+rce)*(1.0+rce))/((sigmaf2+1.0/sigmaf2)*(sigmaf2+1.0/sigmaf2))'


*** PLOT spatial map

'page 4 1'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 260 300'
'set lat 45 75'
'set ylint 10'
'set xlint 10'
'set clevs 0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9'
'set ccols 0 14 4 11 5 13 7 12 8 2 6'
'd t1'
'cbarn'
'draw title (a) TSS between snow2dvar and Crocus'

'page 4 2'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 260 300'
'set lat 45 75'
'set ylint 10'
'set xlint 10'
'set clevs 0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9'
'set ccols 0 14 4 11 5 13 7 12 8 2 6'
'd t2'
'cbarn'
'draw title (b) TSS between snow2dvar and ERA5'

'page 4 3'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 260 300'
'set lat 45 75'
'set ylint 10'
'set xlint 10'
'set clevs -0.25 -0.2 -0.15 -0.1 -0.05 0.05 0.1 0.15 0.2 0.25'
'set ccols 14 4 11 5 13 0 7 12 8 2 6'
'd (t1-t3)'
'cbarn'
'draw title (c) TSS snow2dvar-control: Refer to Crocus'

'page 4 4'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 260 300'
'set lat 45 75'
'set ylint 10'
'set xlint 10'
'set clevs -0.25 -0.2 -0.15 -0.1 -0.05 0.05 0.1 0.15 0.2 0.25'
'set ccols 14 4 11 5 13 0 7 12 8 2 6'
'd (t2-t4)'
'cbarn'
'draw title (d) TSS snow2dvar-control: refer to ERA5'


'gxprint US_Canada_TaylorSkillScore_snowDepth.png white x1100 y850'
*'quit'
