****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

say 'Opening control gdas snow data'
'open control_00z_oct-dec2024.ctl'
'set t 1 92'
'define csd11=1000*maskout(snodsfc,snodsfc)'
'close 1'

say 'Opening snow2dvar gdas snow data'
'open snow2dvar_oct-dec_2024.ctl'
'set t 1 92'
'define vsd11=1000*maskout(snodsfc,snodsfc)'
'close 1'

say 'Opening era5 snow data'
'open era5_grib2_grid.ctl'
'set t 1 91'
'define sd21=maskout((1000*swe/(snowdensity*0.001)),swe)'

*** PLOT spatial map
'set t 75'
'page 4 1'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 235 295'
'set lat 25 50'
'set ylint 5'
'set xlint 10'
'set clevs 0 10 30 50 70 90 110 130 150 200'
'set ccols 0 14 4 11 5 13 7 12 8 2 6'
'd csd11'
'cbarn'
'draw title (a) Control 20241114'

'set t 75'
'page 4 2'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 235 295'
'set lat 25 50'
'set ylint 5'
'set xlint 10'
'set clevs 0 10 30 50 70 90 110 130 150 200'
'set ccols 0 14 4 11 5 13 7 12 8 2 6'
'd vsd11'
'cbarn'
'draw title (b) 2dvar 20241114'

'set t 75'
'page 4 3'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 235 295'
'set lat 25 50'
'set ylint 5'
'set xlint 10'
'set clevs 0 10 30 50 70 90 110 130 150 200'
'set ccols 0 14 4 11 5 13 7 12 8 2 6'
'd sd21'
'cbarn'
'draw title (c) era5 20241114'

'set t 75'
'page 4 4'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 235 295'
'set lat 25 50'
'set ylint 5'
'set xlint 10'
'set clevs -50 -40 -30 -20 -10 10 20 30 40 50'
'set ccols 14 4 11 5 13 0 7 12 8 2 6'
'd (vsd11-sd21)'
'cbarn'
'draw title (c) Control 20241114'

'gxprint Check_US_snowDepth_14Nov2024_00Z.png white x1100 y850'
*'quit'
