****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

say 'Opening control data'
'open control_00z_oct-dec2024.ctl'
'set t 1'
'define csw11=ave(maskout(weasdsfc,weasdsfc),t=1, t=92)'
'define csd11=1000*ave(maskout(snodsfc,snodsfc),t=1, t=92)'
'close 1'

say 'Opening 2dvar gdas snow data'
'open snow2dvar_oct-dec_2024.ctl'
'set t 1'
'define vsw11=ave(maskout(weasdsfc,weasdsfc),t=1, t=92)'
'define vsd11=1000*ave(maskout(snodsfc,snodsfc),t=1,t=92)'
'close 1'

say 'Opening era5 snow data'
'open era5_grib2_grid.ctl'
'set t 1'
'define sw21=1000*ave(maskout(swe,swe),t=1,t=92)'
'define sd21=ave(maskout((1000*swe/(snowdensity*0.001)),swe),t=1,t=92)'
'close 1'

say 'OPENING snodas snow data'
'open snodas_grib2_grid.ctl'
'set t 1'
'define sw41=ave(maskout(swe,swe),t=1,t=92)'
'define sd41=ave(maskout(snod,snod),t=1,t=92)'

'set t 1'
'define sd1=csd11-sd21'
'define sd2=csd11-sd41'
'define sd3=vsd11-sd21'
'define sd4=vsd11-sd41'

'define sw1=csw11-sw21'
'define sw2=csw11-sw41'
'define sw3=vsw11-sw21'
'define sw4=vsw11-sw41'

*** PLOT spatial map

'page 4 1'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 235 295'
'set lat 25 50'
'set ylint 20'
'set xlint 50'
'set clevs -18 -14 -10 -6 -2 2 6 10 14 18'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sw1'
'cbarn'
'draw title (a) Control-ERA5'

'page 4 2'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 235 295'
'set lat 25 50'
'set ylint 20'
'set xlint 50'
'set clevs -18 -14 -10 -6 -2 2 6 10 14 18'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sw2'
'cbarn'
'draw title (b) Control-SNODAS'

'page 4 3'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 235 295'
'set lat 25 50'
'set ylint 20'
'set xlint 50'
'set clevs -18 -14 -10 -6 -2 2 6 10 14 18'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sw3'
'cbarn'
'draw title (c) 2dvar-ERA5'

'page 4 4'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 235 295'
'set lat 25 50'
'set ylint 20'
'set xlint 50'
'set clevs -18 -14 -10 -6 -2 2 6 10 14 18'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd sw4'
'cbarn'
'draw title (d) 2dvar-SNODAS'


'gxprint Bias_SWE_referTo_ERA5_SNODAS.png white x1100 y850'
*'quit'
