****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

say 'Opening control gdas snow data'
'open control_00z_oct2024-mar2025.ctl'
'set lon 235'
'set lat 25'
'set t 1 175'
'define csw11=tloop(aave(weasdsfc,lon=235,lon=260,lat=25,lat=50))'
'define csd11=1000*tloop(aave(snodsfc,lon=235,lon=260,lat=25,lat=50))'

'set lon 260'
'set lat 25'
'set t 1 175'
'define csw21=tloop(aave(weasdsfc,lon=260,lon=295,lat=25,lat=50))'
'define csd21=1000*tloop(aave(snodsfc,lon=260,lon=295,lat=25,lat=50))'
'close 1'

say 'Opening snow2dvar gdas snow data'
'open snow2dvar_oct2024-mar2025.ctl'
'set lon 235'
'set lat 25'
'set t 1 175'
'define vsw11=tloop(aave(weasdsfc,lon=235,lon=260,lat=25,lat=50))'
'define vsd11=1000*tloop(aave(snodsfc,lon=235,lon=260,lat=25,lat=50))'

'set lon 260'
'set lat 25'
'set t 1 175'
'define vsw21=tloop(aave(weasdsfc,lon=260,lon=295,lat=25,lat=50))'
'define vsd21=1000*tloop(aave(snodsfc,lon=260,lon=295,lat=25,lat=50))'
'close 1'

say 'Opening snodas snow data'
'open snodas_grib2_grid.ctl'
'set lon 235'
'set lat 25'
'set t 1 175'
'define sw11=tloop(aave(swe,lon=235,lon=260,lat=25,lat=50))'
'define sd11=tloop(aave(snod,lon=235,lon=260,lat=25,lat=50))'

'set lon 260'
'set lat 25'
'set t 1 175'
'define sw12=tloop(aave(swe,lon=260,lon=295,lat=25,lat=50))'
'define sd12=tloop(aave(snod,lon=260,lon=295,lat=25,lat=50))'
'close 1'

say 'Opening era5 snow data'
'open era5_grib2_grid.ctl'
'set lon 235'
'set lat 25'
'set t 1 175'
'define sw21=1000*tloop(aave(swe,lon=235,lon=260,lat=25,lat=50))'
'define sd21=tloop(aave(1000*swe/(snowdensity*0.001),lon=235,lon=260,lat=25,lat=50))'

'set lon 260'
'set lat 25'
'set t 1 175'
'define sw22=1000*tloop(aave(swe,lon=260,lon=295,lat=25,lat=50))'
'define sd22=tloop(aave(1000*swe/(snowdensity*0.001),lon=260,lon=295,lat=25,lat=50))'

*** PLOT daily time series
'page 4 1'
'set t 1 180'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 0 60'
'set ylint 15'
'set xlabs 01Oct24|29Nov24|28Jan25|28Mar25'
'set cthick 6'
'set cstyle 1'
'set ccolor 3'
'set cmark 0'
'd sw11'
'set cthick 6'
'set cstyle 1'
'set ccolor 1'
'set cmark 0'
'd sw21'
'set cthick 6'
'set cstyle 1'
'set ccolor 4'
'set cmark 0'
'd csw11'
'set cthick 6'
'set cstyle 1'
'set ccolor 2'
'set cmark 0'
'd vsw11'

'draw xlab Day'
'draw ylab Snow Water Equivalent (mm)' 
'draw title (a) Western US'

'set strsiz .15'
'set line '3' '1' 5'
'draw line 2.8 7.5 3.3 7.5'
'set string '3' l 6 0'
'draw string 3.4 7.5 snodas'

'set strsiz .15'
'set line '1' '1' 5'
'draw line 2.8 7.2 3.3 7.2'
'set string '1' l 6 0'
'draw string 3.4 7.2 era5'

'set line '4' '1' 5'
'draw line 2.8 6.9 3.3 6.9'
'set string '4' l 6 0'
'draw string 3.4 6.9 control'

'set line '2' '1' 5'
'draw line 2.8 6.6 3.3 6.6'
'set string '2' l 6 0'
'draw string 3.4 6.6 2dvar'

'page 4 2'
'set t 1 180'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 0 200'
'set ylint 50'
'set xlabs 01Oct24|29Nov24|28Jan25|28Mar25'
'set cthick 6'
'set cstyle 1'
'set ccolor 3'
'set cmark 0'
'd sd11'
'set cthick 6'
'set cstyle 1'
'set ccolor 1'
'set cmark 0'
'd sd21'
'set cthick 6'
'set cstyle 1'
'set ccolor 4'
'set cmark 0'
'd csd11'
'set cthick 6'
'set cstyle 1'
'set ccolor 2'
'set cmark 0'
'd vsd11'

'draw xlab Day'
'draw ylab Snow Depth (mm)'
'draw title (b) Western US'

'page 4 3'
'set t 1 180'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 0 40'
'set ylint 10'
'set xlabs 01Oct24|29Nov24|28Jan25|28Mar25'
'set cthick 6'
'set cstyle 1'
'set ccolor 3'
'set cmark 0'
'd sw12'
'set cthick 6'
'set cstyle 1'
'set ccolor 1'
'set cmark 0'
'd sw22'
'set cthick 6'
'set cstyle 1'
'set ccolor 4'
'set cmark 0'
'd csw21'
'set cthick 6'
'set cstyle 1'
'set ccolor 2'
'set cmark 0'
'd vsw21'

'draw xlab Day'
'draw ylab Snow Water Equivalent (mm)'
'draw title (c) Eastern US'

'page 4 4'
'set t 1 180'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 0 200'
'set ylint 50'
'set xlabs 01Oct24|29Nov24|28Jan25|28Mar25'
'set cthick 6'
'set cstyle 1'
'set ccolor 3'
'set cmark 0'
'd sd12'
'set cthick 6'
'set cstyle 1'
'set ccolor 1'
'set cmark 0'
'd sd22'
'set cthick 6'
'set cstyle 1'
'set ccolor 4'
'set cmark 0'
'd csd21'
'set cthick 6'
'set cstyle 1'
'set ccolor 2'
'set cmark 0'
'd vsd21'

'draw xlab Day'
'draw ylab Snow Depth (mm)'
'draw title (d) Eatern US'

'gxprint WeaternUS_EasternUS_SWE_snowDepth_timeseries_1Oct24-28Mar2025_00Z.png white x1100 y850'
*'quit'
