****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

say 'Opening control gdas snow data'
'open control_00z_JanToMar.ctl'
'set lon 240'
'set lat 35'
'set t 1 90'
'define ct11=tloop(aave(tmp2m,lon=240,lon=250,lat=35,lat=45))'
'define cq11=tloop(aave(spfh2m,lon=240,lon=250,lat=35,lat=45))'
'set lon 70'
'set lat 29'
'set t 1 90'
'define ct12=tloop(aave(tmp2m,lon=70,lon=120,lat=35,lat=45))'
'define cq12=tloop(aave(spfh2m,lon=70,lon=120,lat=35,lat=45))'
'close 1'

say 'Opening snow2dvar gdas snow data'
'open snow2dvar_00z_JanToMar.ctl'
'set lon 240'
'set lat 35'
'set t 1 90'
'define vt11=tloop(aave(tmp2m,lon=240,lon=250,lat=35,lat=45))'
'define vq11=tloop(aave(spfh2m,lon=240,lon=250,lat=35,lat=45))'
'set lon 70'
'set lat 29'
'set t 1 90'
'define vt12=tloop(aave(tmp2m,lon=70,lon=120,lat=35,lat=45))'
'define vq12=tloop(aave(spfh2m,lon=70,lon=120,lat=35,lat=45))'

*** PLOT daily time series
'page 4 1'
'set t 1 90'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 260 295'
'set ylint 5'
'set xlabs 01Jan|30Jan|02Mar|31Mar'
'set cthick 6'
'set cstyle 1'
'set ccolor 3'
'set cmark 0'
'd ct11'
'set cthick 6'
'set cstyle 1'
'set ccolor 9'
'set cmark 0'
'd vt11'

'draw xlab Day'
'draw ylab Tair (K)' 
'draw title (a) West US [110-120oW,35-45oN]'

'set line '3' '1' 5'
'draw line 2.8 6.3 3.3 6.3'
'set string '3' l 6 0'
'draw string 3.4 6.3 control'

'set line '9' '1' 5'
'draw line 2.8 6.0 3.3 6.0'
'set string '9' l 6 0'
'draw string 3.4 6.0 snow2dvar'


'page 4 2'
'set t 1 90'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 255 275'
'set ylint 5'
'set xlabs 01Jan|30Jan|02Mar|31Mar'
'set cthick 6'
'set cstyle 1'
'set ccolor 3'
'set cmark 0'
'd ct12'
'set cthick 6'
'set cstyle 1'
'set ccolor 9'
'set cmark 0'
'd vt12'

'draw xlab Day'
'draw ylab Tair (K)'
'draw title (b) Tibetan area (70-120oE, 35-45oN]'

'page 4 3'
'set t 1 90'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 1 5'
'set ylint 1'
'set xlabs 01Jan|30Jan|02Mar|31Mar'
'set cthick 6'
'set cstyle 1'
'set ccolor 3'
'set cmark 0'
'd cq11*1000'
'set cthick 6'
'set cstyle 1'
'set ccolor 9'
'set cmark 0'
'd vq11*1000'

'draw xlab Day'
'draw ylab Qair (g/kg)'
'draw title (c) West US [110-120oW,35-45oN]'

'page 4 4'
'set t 1 90'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 0.5 3'
'set ylint 0.5'
'set xlabs 01Jan|30Jan|02Mar|31Mar'
'set cthick 6'
'set cstyle 1'
'set ccolor 3'
'set cmark 0'
'd cq12*1000'
'set cthick 6'
'set cstyle 1'
'set ccolor 9'
'set cmark 0'
'd vq12*1000'

'draw xlab Day'
'draw ylab Qair (g/kg)'
'draw title (d) Tibetan area (70-120oE, 35-45oN]'

'gxprint WestUS_Tibetan_Tair_Qair_timeseries_1Jan-31Mar2022_00Zcyc.png white x1100 y850'
*'quit'
