****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

say 'Opening basin mask'
* Colorado River Basin
'open river_basin_grib2_grid.ctl'
'define mask2=maskout(basins,2434-basins)'
'define mask22=maskout(mask2,mask2-2434)'
'close 1'

say 'Opening control gdas snow data'
'open control_00z_JanToMar.ctl'
'set lon 101'
'set lat 34'
'set t 1 90'
'define csw12=tloop(aave(maskout(weasdsfc,mask22),lon=101,lon=106,lat=34,lat=36.5))'
'define csd12=1000*tloop(aave(maskout(snodsfc,mask22),lon=101,lon=106,lat=34,lat=36.5))'
'close 1'

say 'Opening snow2dvar gdas snow data'
'open snow2dvar_00z_JanToMar.ctl'
'set lon 101'
'set lat 34'
'set t 1 90'
'define vsw12=tloop(aave(maskout(weasdsfc,mask22),lon=101,lon=106,lat=34,lat=36.5))'
'define vsd12=1000*tloop(aave(maskout(snodsfc,mask22),lon=101,lon=106,lat=34,lat=36.5))'

*** PLOT daily time series

'page 4 1'
'set t 1 90'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 0 100'
'set ylint 20'
'set xlabs 1J|11J|21J|31J|10F|20F|02M|12M|22M|31M'
'set cthick 6'
'set cstyle 1'
'set ccolor 3'
'set cmark 0'
'd csw12'
'set cthick 6'
'set cstyle 1'
'set ccolor 9'
'set cmark 0'
'd vsw12'

'draw xlab Day'
'draw ylab Snow Water Equivalent (mm)'
'draw title (a) Yellow River Basin'

'page 4 2'
'set t 1 90'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 0 300'
'set ylint 100'
'set xlabs 1J|11J|21J|31J|10F|20F|02M|12M|22M|31M'
'set cthick 6'
'set cstyle 1'
'set ccolor 3'
'set cmark 0'
'd csd12'
'set cthick 6'
'set cstyle 1'
'set ccolor 9'
'set cmark 0'
'd vsd12'

'draw xlab Day'
'draw ylab Snow Depth (mm)'
'draw title (b) Yellow River Basin'

'page 4 3'
'set t 1 90'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange -20 100'
'set ylint 20'
'set xlabs 1J|11J|21J|31J|10F|20F|02M|12M|22M|31M'
'set cthick 6'
'set cstyle 1'
'set ccolor 9'
'set cmark 0'
'd vsw12-csw12'

'draw xlab Day'
'draw ylab Snow Water Equivalent (mm)'
'draw title (c) 2dvar-Ctrl SWE(mm)'


'page 4 4'
'set t 1 90'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange -100 200'
'set ylint 100'
'set xlabs 1J|11J|21J|31J|10F|20F|02M|12M|22M|31M'
'set cthick 6'
'set cstyle 1'
'set ccolor 9'
'set cmark 0'
'd vsd12-csd12'

'draw xlab Day'
'draw ylab Snow Depth (mm)'
'draw title (d) 2dvar-Ctrl Snow Depth(mm)'

'gxprint Yellow_SWE_snowDepth_timeseries_1Jan-31Mar2022_00Z.png white x1100 y850'
*'quit'
