****** Verify GFSv16, HR1, HR2 using CMC snow depth******
******** PLOT time series ******

'reinit'
'set display color white'
'clear'

say 'Opening basin mask'
* Yellow River Basin
'sdfopen /scratch2/NCEPDEV/land/data/evaluation/basins/prototype/GRDC_prototype.nc'
'define mask2=maskout(basins,2434-basins)'
'define mask22=maskout(mask2,mask2-2434)'
'close 1'

say 'Opening control gdas snow data'
'sdfopen /scratch2/NCEPDEV/land/Youlong.Xia/coupledSnow2dvar_forcing/control/orig/control_forcing_202201.nc'
'set lon 101'
'set lat 34'
'set t 1 248'
'define ct11=tloop(aave(maskout(temperature,mask22),lon=101,lon=106,lat=34,lat=36.5))'
'define cp11=86400*tloop(aave(maskout(precipitation,mask22),lon=101,lon=106,lat=34,lat=36.5))'
'close 1'

say 'Opening snow2dvar gdas snow data'
'sdfopen /scratch2/NCEPDEV/land/data/ufs-land-driver/datm/SNOW2DVAR/orig/snow2dvar_forcing_202201.nc'
'set lon 101'
'set lat 34'
'set t 1 248'
'define vt11=tloop(aave(maskout(temperature,mask22),lon=101,lon=106,lat=34,lat=36.5))'
'define vp11=86400*tloop(aave(maskout(precipitation,mask22),lon=101,lon=106,lat=34,lat=36.5))'


*** PLOT daily time series
'page 2 1'
'set t 1 248'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 250 275'
'set ylint 5'
'set xlabs 01|05|10|15|20|25|31'
'set cthick 6'
'set cstyle 1'
'set ccolor 3'
'set cmark 0'
'd ct11'
'set cthick 6'
'set cstyle 1'
'set ccolor 9'
'set cmark 0'
'd vt11'

'draw xlab Day'
'draw ylab Tair (K)' 
'draw title (a) Yellow River Basin 1-31 Jan 2022'

'set line '3' '1' 5'
'draw line 2.8 6.3 3.3 6.3'
'set string '3' l 6 0'
'draw string 3.4 6.3 control'

'set line '9' '1' 5'
'draw line 2.8 6.0 3.3 6.0'
'set string '9' l 6 0'
'draw string 3.4 6.0 snow2dvar'


'page 2 2'
'set t 1 248'
'set gxout line'
'set grid off'
'set grads off'
'set xlopts 1 5 0.18'
'set vrange 0 10'
'set ylint 2'
'set xlabs 01|05|10|15|20|25|31'
'set cthick 6'
'set cstyle 1'
'set ccolor 3'
'set cmark 0'
'd cp11'
'set cthick 6'
'set cstyle 1'
'set ccolor 9'
'set cmark 0'
'd vp11'

'draw xlab Day'
'draw ylab Precipitation (mm/day)'
'draw title (b) Yellow River Basin 1-31 JAN 2022'

'gxprint YellowRiver_Tair_precip_timeseries_1-31JAN2022.png white x1100 y850'
*'quit'
