***** Verify 2dvar, letkfoi, control SWE and SNOD difference ******
******** PLOT Spatial Map ******

'reinit'
'set display color white'
'clear'

* Yellow River Basin
'open river_basin_grib2_grid.ctl'
'define mask2=maskout(basins,2434.0-basins)'
'define mask22=maskout(mask2,mask2-2434.0)'
'close 1'

say 'Opening 2dvar data'
'open snow2dvar_00z_JanToMar.ctl'
'set t 47'
'define swe1=ave(maskout(weasdsfc,mask22),t=1,t=46)'
'define snod1=ave(maskout(snodsfc*1000,mask22),t=1,t=46)'
'close 1'

say 'OPENING control data'
'open control_00z_JanToMar.ctl'
'set t 47'
'define swe2=ave(maskout(weasdsfc,mask22),t=1,t=46)'
'define snod2=ave(maskout(snodsfc*1000,mask22),t=1,t=46)'

'page 4 1'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 96 116'
'set lat 34 38'
'set ylint 1'
'set xlint 4'
'set clevs 0 1 3 6 9 12 15 18 21 24'
'set ccols 0 6 2 8 12 7 13 5 11 4 14'
'd swe2'
'cbarn'
'draw title (a) SWE control (mm) 1Jan-15Feb 2022 00Z'

'page 4 2'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 96 116'
'set lat 34 38'
'set ylint 1'
'set xlint 4'
'set clevs 0 5 10 15 20 25 30 35 40 45'
'set ccols 0 6 2 8 12 7 13 5 11 4 14'
'd snod2'
'cbarn'
'draw title (b) SNOD control (mm) 1Jan-15Feb 2022 00Z'

'page 4 3'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 96 116'
'set lat 34 38'
'set ylint 1'
'set xlint 4'
'set clevs -20 -15 -10 -5 -1 1 5 10 15 20'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd (swe1-swe2)'
'cbarn'
'draw title (c) 2dvar-control SWE(mm) 1Jan-15Feb 2022 00Z'

'page 4 4'
'set mproj scaled'
'set gxout grfill'
'set grid off'
'set grads off'
'set lon 96 116'
'set lat 34 38'
'set ylint 1'
'set xlint 4'
'set clevs -30 -25 -20 -15 -5 5 15 20 25 30'
'set ccols 6 2 8 12 7 0 13 5 11 4 14'
'd (snod1-snod2)'
'cbarn'
'draw title (d) 2dvar-control SNOD(mm) 1Jan-15Feb 2022 00Z'

'gxprint YellowRiver_withMask_SWE_SNOD_2dvar-control_1Jan-15Feb2022_00Z.png white x1100 y850'
*'quit'

