program gdas_lat

  use netcdf
  implicit none

! define gdas input file
  character*256                :: gdas_file="/scratch2/NCEPDEV/stmp3/Youlong.Xia/coulped_snowDA/COMROOT/snowvar3/gdas.20210928/12/gdas.t12z.sfcanl.nc"
  character*256                :: output_filepath="./"

  integer, parameter  :: grid_yt = 768

  real, dimension(grid_yt) :: latitude
  real, dimension(grid_yt) :: lat

  integer :: error, ncid, dimid, varid, status   ! netcdf identifiers
  integer :: dim_id_i, dim_id_t  ! netcdf dimension identifiers
  integer :: j, j1

! --------- read lat from gdas input file -----------
error = nf90_open(trim(gdas_file), NF90_NOWRITE, ncid)
  call netcdf_err(error, 'opening file: '//trim(gdas_file) )

error = nf90_inq_varid(ncid, 'grid_yt', varid)
 call netcdf_err(error, 'inquire latitude variable' )
error = nf90_get_var(ncid, varid, latitude)
 call netcdf_err(error, 'reading latitude variable' )

error = nf90_close(ncid)
 call netcdf_err(error, 'closing file: '//trim(gdas_file) )

do j=1,grid_yt
j1=grid_yt+1-j
lat(j1)=latitude(j)
enddo

open(10, file='lat.txt')
write(10,*) lat
close(10)

end program


!--------------------------------------------------------------
! if a netcdf call returns an error, print out a message
! and stop processing.
!--------------------------------------------------------------
subroutine netcdf_err( err, string )

use netcdf

implicit none

integer, intent(in) :: err
character(len=*), intent(in) :: string
character(len=80) :: errmsg

if( err == nf90_noerr )return
errmsg = nf90_strerror(err)
print*,''
print*,'fatal error: ', trim(string), ': ', trim(errmsg)
print*,'stop.'
stop 10

return

end subroutine netcdf_err
