#! /bin/sh -l


export scripts=/scratch1/NCEPDEV/da/Youlong.Xia/psl_ClaraDraper/snowCoverCalFV3/ush/
export EXEC_DIR=/scratch2/NCEPDEV/stmp3/Youlong.Xia/OfflineConverters_v2land/v3_madis/
export input_dir=/scratch2/NCEPDEV/land/data/DA/snow_depth/MADIS/6hourly
export output_dir=/scratch2/NCEPDEV/land/data/DA/snow_depth/MADIS/data_proc/v3 

#sdate=20211101
#edate=20220531

sdate=20210101
edate=20211101

while [ $sdate -le $edate ]; do
   year=`echo $sdate |cut -c1-4`

export input_file1=$input_dir/${sdate}_0000
export input_file2=$input_dir/${sdate}_0600
export input_file3=$input_dir/${sdate}_1200
export input_file4=$input_dir/${sdate}_1800

export out_file1=$output_dir/$year/madis_snow_${sdate}_0000.nc
export out_file2=$output_dir/$year/madis_snow_${sdate}_0600.nc
export out_file3=$output_dir/$year/madis_snow_${sdate}_1200.nc
export out_file4=$output_dir/$year/madis_snow_${sdate}_1800.nc
#echo $input_file1
#echo $out_file1
python madis_snow2ioda.py -i $input_file1 -o $out_file1 -m default
python madis_snow2ioda.py -i $input_file2 -o $out_file2 -m default
python madis_snow2ioda.py -i $input_file3 -o $out_file3 -m default
python madis_snow2ioda.py -i $input_file4 -o $out_file4 -m default

echo $sdate
sdate=`$scripts/finddate.sh $sdate d+1`

done
