#!/bin/sh
set -ux

YR="2015"
CYC="00 06 12 18"
FHRS="00 01 02 03 04 05 06"

export STDATE=2015052800
export EDDATE=2016123118

SDATE=`echo $STDATE |cut -c1-10`
EDATE=`echo $EDDATE |cut -c1-10`

DDATE=`expr $SDATE + 0`
  while [ $DDATE -le $EDATE ]
  do
   YYYY=`echo $DDATE |cut -c1-4`
   MM=`echo $DDATE |cut -c5-6`
   DD=`echo $DDATE |cut -c7-8`
   HH=`echo $DDATE |cut -c9-10`

htar -xvf /NCEPPROD/hpssprod/runhistory/rh${YYYY}/${YYYY}${MM}/${YYYY}${MM}${DD}/com_gfs_prod_gdas.${DDATE}.tar ./gdas1.t${HH}z.sfluxgrbf00.grib2 ./gdas1.t${HH}z.sfluxgrbf01.grib2 ./gdas1.t${HH}z.sfluxgrbf02.grib2 ./gdas1.t${HH}z.sfluxgrbf03.grib2 ./gdas1.t${HH}z.sfluxgrbf04.grib2 ./gdas1.t${HH}z.sfluxgrbf05.grib2 ./gdas1.t${HH}z.sfluxgrbf06.grib2

   for HR in $FHRS; do
    mv gdas1.t${HH}z.sfluxgrbf${HR}.grib2 gdas1.${YYYY}${MM}${DD}.t${HH}z.sfluxgrbf${HR}.grib2
    ifile=gdas1.${YYYY}${MM}${DD}.t${HH}z.sfluxgrbf${HR}.grib2
    ofile_tmp=gdas1.${YYYY}${MM}${DD}.t${HH}z.sfluxgrbf${HR}

    wgrib2 -s ${ifile} | grep ":TMP:2 m" | wgrib2 -i ${ifile} -append -grib  ${ofile_tmp}
    wgrib2 -s ${ifile} | grep ":SPFH:2 m" | wgrib2 -i ${ifile} -append -grib  ${ofile_tmp}
    wgrib2 -s ${ifile} | grep ":DSWRF:surface:0" | wgrib2 -i ${ifile} -append  -grib ${ofile_tmp}
    wgrib2 -s ${ifile} | grep ":DLWRF:surface:0" | wgrib2 -i ${ifile} -append  -grib ${ofile_tmp}
    wgrib2 -s ${ifile} | grep ":UGRD:10 m" | wgrib2 -i ${ifile} -append  -grib  ${ofile_tmp}
    wgrib2 -s ${ifile} | grep ":VGRD:10 m" | wgrib2 -i ${ifile} -append  -grib  ${ofile_tmp}
    wgrib2 -s ${ifile} | grep ":PRES:sur" | wgrib2 -i ${ifile}  -append -grib  ${ofile_tmp}
    wgrib2 -s ${ifile} | grep ":PRATE:sur" | wgrib2 -i ${ifile} -append -grib ${ofile_tmp}
    wgrib2 -s ${ifile} | grep "HGT:1 hybrid" | wgrib2 -i ${ifile} -append -grib ${ofile_tmp}
    wgrib2 -s ${ifile} | grep ":VEG" | wgrib2 -i ${ifile} -append -grib ${ofile_tmp}

 /bin/rm $ifile
  done

   DDATE=`/scratch4/NCEPDEV/global/save/glopara/nwpara/util/exec/ndate 6 $DDATE`
  done

