#!/bin/sh
# on hera:

export inputdir=/scratch2/NCEPDEV/stmp3/Youlong.Xia/fromHPSS/2dvarHistory

analdate=2021120100
while [ $analdate -le 2022123118 ];do
   YYYY=`expr $analdate | cut -c1-4`
   MM=`expr $analdate | cut -c5-6`
   DD=`expr $analdate | cut -c7-8`
   HH=`expr $analdate | cut -c9-10`
   # get valid date for fhr00 files
   date1=`./incdate.sh $analdate -6`
   # get valid date for fhr03 files
   date2=`./incdate.sh $analdate -3`
   cp $inputdir/gdas.${YYYY}${MM}${dd}/${HH}/model/atmos/history/gdas.t${HH}z.sfcf000.nc .
   cdo selname,prateb_ave,dswrf_ave,tmp2m,spfh2m,ugrd10m,vgrd10m,pressfc,dlwrf_ave gdas.t${HH}z.sfcf000.nc snow2dvar_forcing_${date1}.nc
   if [ $? -eq 0 ]; then
      rm -rf gdas.t${HH}z.sfcf000.nc
   fi
   cp $inputdir/gdas.${YYYY}${MM}${dd}/${HH}/model/atmos/history/gdas.t${HH}z.sfcf003.nc .
   cdo selname,prateb_ave,dswrf_ave,tmp2m,spfh2m,ugrd10m,vgrd10m,pressfc,dlwrf_ave gdas.t${HH}z.sfcf003.nc snow2dvar_forcing_forcing_${date2}.nc
   if [ $? -eq 0 ]; then
      rm -rf gdas.t${HH}z.sfcf003.nc
   fi
   analdate=`./incdate.sh $analdate 6`
done
