#!/bin/sh
# on hera:
aws=/scratch2/BMC/gsienkf/UFS-RNR/UFS-RNR-stack/bin/aws
analdate=1994050100
while [ $analdate -le 2024010200 ];do
   YYYY=`expr $analdate | cut -c1-4`
   MM=`expr $analdate | cut -c5-6`
   DD=`expr $analdate | cut -c7-8`
   HH=`expr $analdate | cut -c9-10`
   # get valid date for fhr00 files
   date1=`./incdate.sh $analdate -6`
   # get valid date for fhr03 files
   date2=`./incdate.sh $analdate -3`
   $aws s3 cp s3://noaa-ufs-gefsv13replay-pds/${YYYY}/${MM}/${analdate}/bfg_${analdate}_fhr00_control bfg_${date1}.nc --no-sign-request
   cdo selname,prateb_ave,dswrf_ave,tmp2m,spfh2m,ugrd10m,vgrd10m,pressfc,dlwrf_ave bfg_${date1}.nc replay_forcing_${date1}.nc
   if [ $? -eq 0 ]; then
      rm bfg_${date1}.nc
   fi
   $aws s3 cp s3://noaa-ufs-gefsv13replay-pds/${YYYY}/${MM}/${analdate}/bfg_${analdate}_fhr03_control bfg_${date2}.nc --no-sign-request
   cdo selname,prateb_ave,dswrf_ave,tmp2m,spfh2m,ugrd10m,vgrd10m,pressfc,dlwrf_ave bfg_${date2}.nc replay_forcing_${date2}.nc
   if [ $? -eq 0 ]; then
      rm bfg_${date2}.nc
   fi
   analdate=`./incdate.sh $analdate 6`
done
