* plots a box frame by using the lon lat coordinates
*
*  USAGE: run box lonlow lonhigh latlow lathigh
*
*
* NOTE: LON LAT dim must vary and mproj must be latlon
*
*
*
*  AUTHOR: dietmar dommenget
*
function colors(arg)
*
*
*
*
lonlow=subwrd(arg,1)
lonhigh=subwrd(arg,2) 
latlow=subwrd(arg,3)
lathigh=subwrd(arg,4)
if(lathigh='')
say ''
say 'USAGE: run box lonlow lonhigh latlow lathigh'
say ''
say ' NOTE: LON LAT dim must vary and mproj must be latlon'
say ''
return
endif
gxstate()
'query gxinfo'
line=sublin(result,3)
xlow=subwrd(line,4)
xhigh=subwrd(line,6)
line=sublin(result,4)
ylow=subwrd(line,4)
yhigh=subwrd(line,6)
xslope=(xhigh-xlow)/(_lone -_lons)
yslope=(yhigh-ylow)/(_late -_lats)
xoff=xlow-xslope*_lons
yoff=ylow-yslope*_lats
xboxs=xslope*lonlow+xoff
xboxe=xslope*lonhigh+xoff
yboxs=yslope*latlow+yoff
yboxe=yslope*lathigh+yoff
'draw rec 'xboxs' 'yboxs' 'xboxe' 'yboxe
******************************************************
******************************************************
function gxstate()
*
*  Get dimension information as global var _xs,_xe,...
*
'query dim'
dinf = result
lx = sublin(dinf,2)
ly = sublin(dinf,3)
lz = sublin(dinf,4)
lt = sublin(dinf,5)
if ( subwrd(lx,7) = 'to')
  _lons = subwrd(lx,6)
  _lone = subwrd(lx,8)
  _xs = subwrd(lx,11)
  _xe = subwrd(lx,13)
else
  _lons = subwrd(lx,6)
  _lone = subwrd(lx,6)
  _xs = subwrd(lx,9)
  _xe = subwrd(lx,9)
endif
if ( subwrd(ly,7) = 'to')
  _lats = subwrd(ly,6)
  _late = subwrd(ly,8)
  _ys = subwrd(ly,11)
  _ye = subwrd(ly,13)
else
  _lats = subwrd(ly,6)
  _late = subwrd(ly,6)
  _ys = subwrd(ly,9)
  _ye = subwrd(ly,9)
endif
if ( subwrd(lz,7) = 'to')
  _levs = subwrd(lz,6)
  _leve = subwrd(lz,8)
  _zs = subwrd(lz,11)
  _ze = subwrd(lz,13)
else
  _levs = subwrd(lz,6)
  _leve = subwrd(lz,6)
  _zs = subwrd(lz,9)
  _ze = subwrd(lz,9)
endif
if ( subwrd(lt,7) = 'to')
  _tims = subwrd(lt,6)
  _time = subwrd(lt,8)
  _ts = subwrd(lt,11)
  _te = subwrd(lt,13)
else
  _tims = subwrd(lt,6)
  _time = subwrd(lt,6)
  _ts = subwrd(lt,9)
  _te = subwrd(lt,9)
endif
return
******************************************************
*****************************************************

