*compute correlation of a variable, averaged over a box,  with a variable field 
*
*  USAGE: run regression quant1 quant2 lons lone lats late lag
*
*  quant1: quantity in field 
*  quant2: quantity in box 
*  lons lone lats late: box parameter 
*  lag: offset in t-dim for the quant1 
*          quant1 leads quant2 by lag 
*  
*  NOTE: the time range must be >=2 e.g. 'set t 1 3' 
*        the programm defines the variable regres which is the
*        correlation field *    quanty: quantity    
*
*  AUTHOR: dietmar dommenget
*
* 
function regress(arg)
gxstate()
quant1=subwrd(arg,1)
quant2=subwrd(arg,2)
lons=subwrd(arg,3)
lone=subwrd(arg,4)
lats=subwrd(arg,5)
late=subwrd(arg,6)
lag=subwrd(arg,7)
if(lag='');lag=0;endif
if(late='')
  say ''
  say ''
  say '  USAGE: run regression quant1 quant2 lons lone lats late lag'
  say ''
  say '    quant1: quantity in field   '
  say '    quant2: quantity in box    '
  say '    lons lone lats late: box parameter '
  say '    lag: quant1 leads quant2 by lag'
  say ''
  return
endif
'set t '_ts' '_te
'define box=aave('quant2',lon='lons',lon='lone',lat='lats',lat='late')'
tt=_ts
'set t 'tt
time=tt+lag
'define sxy=box*'quant1'(t='time')'
'define sy2='quant1'(t='time')*'quant1'(t='time')'
'define sx2=box*box'
tt=tt+1
while( tt <= _te)
  'set t 'tt
   time=tt+lag
  'define sxy=sxy+box*'quant1'(t='time')'
  'define sy2=sy2+'quant1'(t='time')*'quant1'(t='time')'
  'define sx2=sx2+box*box'
  tt=tt+1
endwhile
'set t 1'
'define regres=sxy/sqrt(sy2*sx2)'
*'c'
*'run col regres '
'run col regres oblack -0.1 0.1 -1 1'
'set line 1'
'run box 'lons' 'lone' 'lats' 'late
*'run cbarn'
*'draw title 'quant1' Regression with 'quant2' in BOX(lon'lons' 'lone'/lat:'lats' 'late') lag='lag
say 'regression field is named: regres'
'set t '_ts' '_te
return
******************************************************
******************************************************
function gxstate()
*
*  Get dimension information as global var _xs,_xe,...
*
'query dim'
dinf = result
lx = sublin(dinf,2)
ly = sublin(dinf,3)
lz = sublin(dinf,4)
lt = sublin(dinf,5)
if ( subwrd(lx,7) = 'to')
  _lons = subwrd(lx,6)
  _lone = subwrd(lx,8)
  _xs = subwrd(lx,11)
  _xe = subwrd(lx,13)
else
  _lons = subwrd(lx,6)
  _lone = subwrd(lx,6)
  _xs = subwrd(lx,9)
  _xe = subwrd(lx,9)
endif
if ( subwrd(ly,7) = 'to')
  _lats = subwrd(ly,6)
  _late = subwrd(ly,8)
  _ys = subwrd(ly,11)
  _ye = subwrd(ly,13)
else
  _lats = subwrd(ly,6)
  _late = subwrd(ly,6)
  _ys = subwrd(ly,9)
  _ye = subwrd(ly,9)
endif
if ( subwrd(lz,7) = 'to')
  _levs = subwrd(lz,6)
  _leve = subwrd(lz,8)
  _zs = subwrd(lz,11)
  _ze = subwrd(lz,13)
else
  _levs = subwrd(lz,6)
  _leve = subwrd(lz,6)
  _zs = subwrd(lz,9)
  _ze = subwrd(lz,9)
endif
if ( subwrd(lt,7) = 'to')
  _tims = subwrd(lt,6)
  _time = subwrd(lt,8)
  _ts = subwrd(lt,11)
  _te = subwrd(lt,13)
else
  _tims = subwrd(lt,6)
  _time = subwrd(lt,6)
  _ts = subwrd(lt,9)
  _te = subwrd(lt,9)
endif
return
******************************************************
*****************************************************
