* compute point to point correlation of two fields
*
function regress(arg)
*
*
*  USAGE: run correlation.point2point quant1 quant2 lag
*
*    quant1,2: quantities    
*    lag: offset in t-dim for the quant1
* 
gxstate()
quant1=subwrd(arg,1)
quant2=subwrd(arg,2)
lag=subwrd(arg,3)
if(lag='');lag=0;endif
if(quant2='')
  say ''
  say ''
  say '  USAGE: run correlation.point2point [quant1] [quant2] [lag]'
  say ''
  say '    quant1: quantity '
  say '    quant2: quantity '
  say '    lag: quant1 leads quant2 by lag'
  say ''
  return
endif
tt=_ts
'set t 'tt
time1=tt+lag
time2=tt
'define sxy='quant1'(t='time1')*'quant2'(t='time2')'
'define sy2='quant1'(t='time1')*'quant1'(t='time1')'
'define sx2='quant2'(t='time2')*'quant2'(t='time2')'
tt=tt+1
while( tt <= _te)
  'set t 'tt
   time1=tt+lag
   time2=tt
  'define sxy=sxy+'quant1'(t='time1')*'quant2'(t='time2')'
  'define sy2=sy2+'quant1'(t='time1')*'quant1'(t='time1')'
  'define sx2=sx2+'quant2'(t='time2')*'quant2'(t='time2')'
  tt=tt+1
endwhile
'set t 1'
'define regres=sxy/sqrt(sy2*sx2)'
*'c'
*'run col regres '
'run col regres onotit oblack -0.1 0.1 1'
'draw title 'quant1' Regression with 'quant2' lag='lag
say 'regression field is named: regres'
'set t '_ts' '_te
return
******************************************************
******************************************************
function gxstate()
*
*  Get dimension information as global var _xs,_xe,...
*
'query dim'
dinf = result
lx = sublin(dinf,2)
ly = sublin(dinf,3)
lz = sublin(dinf,4)
lt = sublin(dinf,5)
if ( subwrd(lx,7) = 'to')
  _lons = subwrd(lx,6)
  _lone = subwrd(lx,8)
  _xs = subwrd(lx,11)
  _xe = subwrd(lx,13)
else
  _lons = subwrd(lx,6)
  _lone = subwrd(lx,6)
  _xs = subwrd(lx,9)
  _xe = subwrd(lx,9)
endif
if ( subwrd(ly,7) = 'to')
  _lats = subwrd(ly,6)
  _late = subwrd(ly,8)
  _ys = subwrd(ly,11)
  _ye = subwrd(ly,13)
else
  _lats = subwrd(ly,6)
  _late = subwrd(ly,6)
  _ys = subwrd(ly,9)
  _ye = subwrd(ly,9)
endif
if ( subwrd(lz,7) = 'to')
  _levs = subwrd(lz,6)
  _leve = subwrd(lz,8)
  _zs = subwrd(lz,11)
  _ze = subwrd(lz,13)
else
  _levs = subwrd(lz,6)
  _leve = subwrd(lz,6)
  _zs = subwrd(lz,9)
  _ze = subwrd(lz,9)
endif
if ( subwrd(lt,7) = 'to')
  _tims = subwrd(lt,6)
  _time = subwrd(lt,8)
  _ts = subwrd(lt,11)
  _te = subwrd(lt,13)
else
  _tims = subwrd(lt,6)
  _time = subwrd(lt,6)
  _ts = subwrd(lt,9)
  _te = subwrd(lt,9)
endif
return
******************************************************
*****************************************************
