* Extracts variables from grib to ascii format
*
* Justin Sheffield <justin@princeton.edu> Feb 2001
*
* commandline execution
*	extract.gs <ctl file> <pts file> <ll|xy> <t1> <t2> <var>

function extract (args)

reset

* get the input args
fctl = subwrd(args,1)
fpts = subwrd(args,2)
type = subwrd(args,3)
t1 = subwrd(args,4)
t2 = subwrd(args,5)

* get the input args vars
i = 6
var = ''
while(subwrd(args, i) != '')
  var = var subwrd(args, i)" "
  i = i + 1
endwhile

* check the args
if(fctl = '' | type = '' | fpts = '' | t1 = '' | t2 = '' | var = '')
  say 'Usage: extract.gs <ctl file> <pts file> <ll|xy> <t1> <t2> <var>'
  return
endif

* check the type
if(type != 'll' & type != 'xy' & type != 'LL' & type != 'XY')
  say 'Error: type must be "ll" or "xy"'
  return
endif

* open the data control file
'open 'fctl

* sets double buffer
'set dbuff on'

* loop through the grid cells
str=read(fpts)
while(sublin(str,1) != 2)

* graphic output
  'set gxout grfill'

* get the lat-lon pairs
  latlon = sublin(str, 2)
  lat = subwrd(latlon, 1)
  lon = subwrd(latlon, 2)
  
* output to file
  fout = "grads_"lat"_"lon".dat"
  ret = write(fout, "")
  
* set the lat-lon
  if(type = "xy" | type = "XY")
    say "extracting point ("lon", "lat")"
    'set x 'lon
    'set y 'lat
  endif
  if(type = "ll" | type = "LL")
    say "extracting point ("lat", "lon")"
    'set lat 'lat
    'set lon 'lon
  endif
  
  time = t1
* loop over time
  while(time <= t2)
  
*   set the time and extract the data
    'set t 'time
  
*   extract the data value from the result string
    'd 'var
    data = time" "subwrd(result, 4)
  
*   write to output
    ret = write(fout, data, append)
        
*   next timestep
    time = time + 1
  
  endwhile
  
  str = read(fpts)

* swap buffer after displaying something
* 'swap'
 
endwhile

'close 1'
*'close (fpts)'

quit
