* This is a test script to getting the climate data to plot

Function main(args)

*SETTING DATE TIME STAMP

'!date > xdate.tmp'
xdate= read('xdate.tmp')
xdate= sublin(xdate,2)
month= substr(xdate,5,3)
day= substr(xdate,9,2)
'! rm -f xdate.tmp'
if(month=Jan)
  month=01
endif
if(month=Feb)
  month=02
endif
if(month=Mar)
  month=03
endif
if(month=Apr)
  month=04
endif


if(day=' 1')
  day=01
endif   
if(day=' 2')
  day=02
endif   
if(day=' 3')
  day=03
endif
if(day=' 4')
  day=04
endif
if(day=' 5')
  day=05
endif   
if(day=' 6')
  day=06
endif
if(day=' 7')
  day=07
endif
if(day=' 7')
  day=07
endif
if(day=' 8')
  day=08
endif
if(day=' 9')
  day=09
endif   

*Clear Everything that might be in GRADS

'reinit'

****
*Getting TIME info

'sdfopen http://cola8.iges.org:9090/dods/mrf'month''day'00b'
'q ctlinfo'
_ctl = result
_undef = getctl(undef)
_tdef = getctl(tdef)
_time1 = subwrd(_tdef,4)

tsize = subwrd(_tdef,2)
    _t1 = (tsize+1)/2
    _t2 = tsize
    tsize = _t2 - _t1 + 1
'set t '_t1' '_t2
'q dims'
 times  = sublin(result,5)
 _time2 = subwrd(times,8)

starthour= substr(_time1,1,3)
endhour= substr(_time2,1,3)
startday= substr(_time1,4,2)
endday= substr(_time2,4,2)
startmonth= substr(_time1,6,3)
endmonth= substr(_time2,6,3)
startyear= substr(_time1,9,4)
endyear= substr(_time2,9,4)
startclimdate = starthour startday startmonth 1979
endclimdate= endhour endday endmonth 1979
startclim2date = starthour startday startmonth
endclim2date= endhour endday endmonth
startclimdate99= starthour startday startmonth 1999
endclimdate99= endhour endday endmonth 1999

'close 1'

*Setting Up Station Data
*To add station just add new name and its given lat and lon and stn id.
n=1
while(n<=1)
if(n=1)
  name  = 'Chicago, IL (KORD)'; hilon = -87.54; hilat = 41.58; stn = KORD
endif


*Setting the Axis on the climo file.

* Setting  Y axis For 2m Temperature
*'open TMP.7995.harmc4.ctl'
*'set lon 'hilon
*'set lat 'hilat
*'set lev 1'
*'d (tmpsfc-273.16)*9/5+32'
*axis= result   
*axis1= subwrd(axis,4)
*upperaxis= axis1+30
*loweraxis= axis1-30
*'close 1'
upperaxis= 60
loweraxis= -10


*Setting Y axis for 850 Temperatures

*'open TMP_daily_clim_harmc4.ctl'
*'set lon 'hilon
*'set lat 'hilat
*'set lev 850'
*'d (tmpprs-273.16)'
*axis2= result
*axis850= subwrd(axis2,4)
*upperaxis850= axis850+25
*loweraxis850= axis850-25
*'close 1'
upperaxis850= 20
loweraxis850= -30




********************************************************************************
********************************************************************************

* Ploting the MRF Model Time Series

'sdfopen http://cola8.iges.org:9090/dods/mrf'month''day'00'
'sdfopen http://cola8.iges.org:9090/dods/mrf'month''day'00b'

'set missconn on'
'set dfile 1'
'set lon 'hilon''
lon1 = subwrd(result,4)
say lon1
'set lat 'hilat''
lat1 = subwrd(result,4)
say lat1
'set dfile 2'
'set lon 'hilon''
lon2 = subwrd(result,4)
say lon2
'set lat 'hilat''
lat2 = subwrd(result,4)
say lat2
'set parea 0.50 8.45 8.0 10.50'
'set xlab on'
'set lev 0'
'set cmark 0'
'set ccolor 2'
'set yaxis 'loweraxis' 'upperaxis' 5'
'set vrange 'loweraxis' 'upperaxis''
'set time '_time1'  '_time2
'define tt=const(t2m.1(lon='lon1',lat='lat1'),0,-u)+const(t2m.2(lon='lon2',lat='lat2'),0,-u)'
'd (tt-273.16)*9/5+32'

* Ploting the 850 temps Time Series

'set parea 0.50 8.45 5.0 7.50'
'set lev 850'
'set cmark 0'
'set ccolor 2'
'set yaxis 'loweraxis850' 'upperaxis850' 5'
'set vrange 'loweraxis850' 'upperaxis850''
'set time '_time1'  '_time2
'define tt850=const(t.1(lon='lon1',lat='lat1'),0,-u)+const(t.2(lon='lon2',lat='lat2'),0,-u)'
'd (tt850-273.16)'


* Ploting the Precip Time Series

'set parea 0.60 8.45 2.0 4.50'
'set lev 0'
'set cmark 0'
'set ccolor 2'
'set yaxis 0.0 2.00 .25'
'set vrange 0.0 2.00'
'set time '_time1'  '_time2
'define ttprecip=const(p.1(lon='lon1',lat='lat1'),0,-u)+const(p.2(lon='lon2',lat='lat2'),0,-u)'
'd ttprecip/25.4'
'set missconn off'
'close 2'
'close 1'


*Plot the AVN Mode Time Series

'sdfopen http://cola8.iges.org:9090/dods/avn'month''day'00'

'set time '_time1'  '_time2
'set lon 'hilon
'set lat 'hilat
'set lev 0'
'set cmark 0'
'set ccolor 3'
'set parea 0.50 8.45 8.0 10.50'
'set yaxis 'loweraxis' 'upperaxis' 5'
'set vrange 'loweraxis' 'upperaxis''
'd (t2m-273.16)*9/5+32' 

* Ploting the 850 temps Time Series
'set parea 0.50 8.45 5.0 7.50'
'set lev 850'
'set cmark 0'
'set ccolor 3'
'set yaxis 'loweraxis850' 'upperaxis850' 5'
'set vrange 'loweraxis850' 'upperaxis850''
'set time '_time1'  '_time2
'd (t-273.16)'

* Ploting the Precip Time Series

'set parea 0.60 8.45 2.0 4.50'
'set lev 0'  
'set cmark 0' 
'set ccolor 3'
'set yaxis 0.0 2.00 .25'
'set vrange 0.0 2.00'
'set time '_time1'  '_time2
'd p/25.4'
'close 1'


*Plot the Eta Model Time Series

'sdfopen http://cola8.iges.org:9090/dods/eta'month''day'00'
'set time '_time1'  '_time2
'set lon 'hilon
'set lat 'hilat
'set lev 0'   
'set cmark 0'
'set ccolor 8'
'set parea 0.50 8.45 8.0 10.50'
'set yaxis 'loweraxis' 'upperaxis' 5'
'set vrange 'loweraxis' 'upperaxis''
'd (t2m-273.16)*9/5+32'


* Ploting the 850 temps Time Series

'set parea 0.50 8.45 5.0 7.50'
'set lev 850'
'set cmark 0'
'set ccolor 8'
'set yaxis 'loweraxis850' 'upperaxis850' 5'
'set vrange 'loweraxis850' 'upperaxis850''
'set time '_time1'  '_time2
'd (t-273.16)'

* Ploting the Precip Time Series

'set parea 0.60 8.45 2.0 4.50'
'set lev 0'   
'set cmark 0'
'set ccolor 8'
'set yaxis 0.0 2.00 .25'
'set vrange 0.0 2.00'
'set time '_time1'  '_time2
'd p/25.4'
'close 1'

****** PLOTING MAP KEY

* Draw the station label And lables and Keys
'set strsiz 0.27 0.20'
'set string 1 l 8 0'
'draw string 0.1 10.79 `1'name

'set line 2 1 2'
'draw line 0.25 1.25 0.75  1.25'
'set strsiz 0.18 0.20'
'set string 1 l 5 0'
*'draw mark 2 0.5 1.25 .1'
'draw string 0.77 1.30 'MRF

'set line 3 1 2'
'draw line 0.25 1.00 0.75 1.00'
'set strsiz 0.18 0.20'
'set string 1 l 5 0'
*'draw mark 3 0.5 1.00 .1'
'draw string 0.77 1.05 `1'AVN

'set line 8 1 2'
'draw line 0.25 0.75 0.75 0.75'
'set strsiz 0.18 0.20'
'set string 1 l 5 0'
*'draw mark 8 0.5 0.75 .1'
'draw string 0.77 0.80 `1'ETA

'set strsiz 0.15 .15'
'set string 7 l 5 90'
t2mtemp= '2m Temperature (F)'
'draw string 0.10 8.25 `1't2mtemp

'set strsiz 0.15 .15'
'set string 7 l 5 90'
second= '850mb Temperature (C)'
'draw string 0.10 4.90 `1'second

'set strsiz 0.15 .15'
'set string 7 l 5 90'
precip= 'Precipitation (in)'
'draw string 0.10 2.30 `1'precip

'set strsiz 0.15 0.15'
'set string 1 l 4 0'
datestamp= 'Generated 2002'month''day''
'draw string 2.25 1.45 `1'datestamp

n=n+1
endwhile

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
function getctl(handle)
line = 1
found = 0
while (!found)
  info = sublin(_ctl,line)
  if (subwrd(info,1)=handle)
    _handle = info
    found = 1
  endif
  line = line + 1
endwhile
return _handle

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
