* Computes multi-year monthly mean (like the extra "baustein")
* If no mean field name is given it is called <field>mn
*
*  WARNING: lmean assumes monthly data
*
*  USAGE: lmean <field> [<mean field name>]
*
*
*  AUTHOR: MATHIAS MUENNICH
*
*	
function lmean(arg)
field=subwrd(arg,1)
if( subwrd(arg,2)='')
  argmn=field'mn'
else
  argmn=subwrd(arg,2)
endif
gxstate()
say '   Computing monthly mean from t=' _ts' to t='_te
say '   Output field: ' argmn
'set t 1 12'
tsm=_ts-1
'define  ' argmn '=ave('field',t+'tsm',t='_te',1yr)'
'modify 'argmn' seasonal'
'set t '_ts' ' _te

******************************************************
******************************************************
function gxstate()
*
*  Get dimension information as global var _xs,_xe,...
*
'query dim'
dinf = result
lx = sublin(dinf,2)
ly = sublin(dinf,3)
lz = sublin(dinf,4)
lt = sublin(dinf,5)
if ( subwrd(lx,7) = 'to')
  _xs = subwrd(lx,11)
  _xe = subwrd(lx,13)
else
  _xs = subwrd(lx,9)
  _xe = subwrd(lx,9)
endif
if ( subwrd(ly,7) = 'to')
  _ys = subwrd(ly,11)
  _ye = subwrd(ly,13)
else
  _ys = subwrd(ly,9)
  _ye = subwrd(ly,9)
endif
if ( subwrd(lz,7) = 'to')
  _zs = subwrd(lz,11)
  _ze = subwrd(lz,13)
else
  _zs = subwrd(lz,9)
  _ze = subwrd(lz,9)
endif
if ( subwrd(lt,7) = 'to')
  _ts = subwrd(lt,11)
  _te = subwrd(lt,13)
else
  _ts = subwrd(lt,9)
  _te = subwrd(lt,9)
endif
return
******************************************************

