* Compute running mean of a field.
*
*  USAGE: runmean <field> <t-> <t+> [<output field name>]
*
*         Compute running mean over t-<t-> to t+<t+> and assign 
*         result to  <output field name>.
*         Default <output field name>: <field>mn.
*
*  Notes: Both <t-> and <t+> must be >=0.
*         If <output field name> == "display" the result 
*         is displayed and not defined in a variable.
*
*  EXAMPLE: runmean sst 2 1 sst4yrmn
*           Averages the field sst over 4 timesteps t-2,t-1,t,t+1 and  
*           defines the  result as sst4yrmn

*  Matthias Muennich 10/95

function runmean (arg)
fld1=subwrd(arg,1)
tm=subwrd(arg,2)
tp=subwrd(arg,3)
mnname=subwrd(arg,4)
if(mnname = '')
  mnname=fld1'rmn'
endif
tt=tm+tp+1
say ' ' tt' time step running means of 'fld1
gxstate()

'set t '_ts' '_te
say ' time: '_ts' to '_te
if(mnname='display')
   'd  tloop(ave(' fld1 ',t-' tm ',t+' tp '))'
else
   'define ' mnname ' = tloop(ave(' fld1 ',t-' tm ',t+' tp '))'
endif
* say ' Running Mean fields computed'
return

function gxstate()
*
*  Get dimension information as global var _xs,_xe,...
*
'query dim'
dinf = result
lx = sublin(dinf,2)
ly = sublin(dinf,3)
lz = sublin(dinf,4)
lt = sublin(dinf,5)
if ( subwrd(lx,7) = 'to')
  _xs = subwrd(lx,11)
  _xe = subwrd(lx,13)
else
  _xs = subwrd(lx,9)
  _xe = subwrd(lx,9)
endif
if ( subwrd(ly,7) = 'to')
  _ys = subwrd(ly,11)
  _ye = subwrd(ly,13)
else
  _ys = subwrd(ly,9)
  _ye = subwrd(ly,9)
endif
if ( subwrd(lz,7) = 'to')
  _zs = subwrd(lz,11)
  _ze = subwrd(lz,13)
else
  _zs = subwrd(lz,9)
  _ze = subwrd(lz,9)
endif
if ( subwrd(lt,7) = 'to')
  _ts = subwrd(lt,11)
  _te = subwrd(lt,13)
else
  _ts = subwrd(lt,9)
  _te = subwrd(lt,9)
endif
return
