*This script make the scatter plot using the standard scatter plot command
*But, before the display, it calculates the following quantities
*
*mean difference
*standard deviation
*root mean square difference
*correlation
*

*modified from scatter.gs, to write the output on screen


function main(args)
var1=subwrd(args,1)
var2=subwrd(args,2)
x=subwrd(args,3)
y=subwrd(args,4)
color=subwrd(args,5)
mark=subwrd(args,6)

if(var1='')
say "USAGE: scatter var1 var2 [x y]"
return
endif

if(color='')
color=1
endif

if(mark='')
mark=3
endif



'set gxout stat'
'd 'var1'*('var2'+888888.)/('var2'+888888.)'
line1=sublin(result,11)
line2=sublin(result,13)
ave1=subwrd(line1,2)
sigma1=subwrd(line2,2)

*say ave1' 'sigma1
'd 'var2'*('var1'+888888.)/('var1'+888888.)'
line1=sublin(result,11)
line2=sublin(result,13)
ave2=subwrd(line1,2)
sigma2=subwrd(line2,2)
*say ave2' 'sigma2

'define prime1='var1'-'ave1
'define prime2='var2'-'ave2

'd prime1*prime2'
line.11=sublin(result,11)
covar=subwrd(line.11,2)
*say covar


*'undefine prime1'
*'undefine prime2'

'd 'var2'-'var1''
i=1
while(sublin(result,i) !='')
line.i=sublin(result,i)
i=i+1
endwhile

total=subwrd(line.5,5)
vcount=subwrd(line.7,8)
mean=subwrd(line.11,2)
stddv=subwrd(line.13,2)
rmsd=subwrd(line.11,4)

fmt = '%5.3f'
mean = math_format(fmt,mean)
stddv = math_format(fmt,stddv)
rmsd = math_format(fmt,rmsd)
if(sigma1 != 0 & sigma2 !=0)
corr=covar/(sigma1*sigma2)
else
corr=0
endif

corr = math_format(fmt,corr)

'set gxout scatter'
'set ccolor 'color
'set cmark 'mark
'd 'var1';'var2
if(subwrd(result,1) !='Cannot')
'121'
status='OK'
endif

'q gxinfo'
yinfo=sublin(result,4)
xinfo=sublin(result,3)
xmn=subwrd(xinfo,4)
xmx=subwrd(xinfo,6)
ymn=subwrd(yinfo,4)
ymx=subwrd(yinfo,6)

if(x='click')
'q pos'
x=subwrd(result,3)
y=subwrd(result,4)
else
if(x='')
x=xmx-0.55
endif

if(y='')
y=ymn+0.85
endif
endif

'set strsiz 0.08 0.08'
*'set string 1 r'
*'draw string 'x' 'y' `5Total Count:`0'
*'set string 1 l'
*'draw string 'x' 'y' 'total

y=y-0.15
say 'Total points: 'vcount
say 'Bias: 'mean
say 'Sigma: 'stddv
say 'RMSD: 'rmsd
say 'R: 'corr

return status
