* spatial correlation between two fields (like correlation for time series)
function regress(arg)
*
*
*  USAGE: run spatial.correlation [field1] [field2] -ogauss
*
*
*
*  AUTHOR: dietmar dommenget
* 
gxstate()
quant1=subwrd(arg,1)
quant2=subwrd(arg,2)
opt=subwrd(arg,3)
if(quant2='')
  say ''
  say ''
  say '  USAGE: run regression quant1 quant2 [-ogauss]'
  say ''
  say '    quant1: quantity in field1   '
  say '    quant2: quantity in field2   '
  say '    -ogauss: use cos(lat) weighted correlation'
  say ''
  return
endif
*
if(opt='');gauss=0;endif
if(opt='-ogauss');gauss=1;endif
if(opt='-ogauss');say 'use cos(lat) weighted correlation';endif
*
* calc means
*
if(gauss=1);'define wgaus=abs(cos(6.283*lat/360.0))';endif
if(gauss=0);'define wgaus=1.0';endif
'define mean1=0.0'
'define mean2=0.0'
*'define mean1=amean('quant1',x='_xs',x='_xe',y='_ys',y='_ye')'
*'define mean2=amean('quant2',x='_xs',x='_xe',y='_ys',y='_ye')'
*
*
*
undef=8.9e27
xx=_xs
yy=_ys
'set x 'xx
'set y 'yy
'define sxy=0.0'
'define sy2=0.0'
'define sx2=0.0'
while( yy <= _ye)
  'set x 'xx
  'set y 'yy
  'd 'quant1'+'quant2
  didi=subwrd(result,4)
*  say 'value= 'didi
  if(didi<=undef);'define sxy=sxy+wgaus*('quant1'-mean1)*('quant2'-mean2)';endif
  if(didi<=undef);'define sy2=sy2+wgaus*('quant1'-mean1)*('quant1'-mean1)';endif
  if(didi<=undef);'define sx2=sx2+wgaus*('quant2'-mean2)*('quant2'-mean2)';endif
  xx=xx+1
  if(xx>_xe);yy=yy+1;endif
*  if(xx>_xe);say 'y='yy' x='xx;endif
  if(xx>_xe);xx=_xs;endif
endwhile
'define regres=sxy/sqrt(sy2*sx2)'
'd regres'
correl=subwrd(result,4)
say 'spatial correlation of 'quant1' with 'quant2' = 'correl
'set x '_xs' '_xe
'set y '_ys' '_ye
return
******************************************************
******************************************************
function gxstate()
*
*  Get dimension information as global var _xs,_xe,...
*
'query dim'
dinf = result
lx = sublin(dinf,2)
ly = sublin(dinf,3)
lz = sublin(dinf,4)
lt = sublin(dinf,5)
if ( subwrd(lx,7) = 'to')
  _lons = subwrd(lx,6)
  _lone = subwrd(lx,8)
  _xs = subwrd(lx,11)
  _xe = subwrd(lx,13)
else
  _lons = subwrd(lx,6)
  _lone = subwrd(lx,6)
  _xs = subwrd(lx,9)
  _xe = subwrd(lx,9)
endif
if ( subwrd(ly,7) = 'to')
  _lats = subwrd(ly,6)
  _late = subwrd(ly,8)
  _ys = subwrd(ly,11)
  _ye = subwrd(ly,13)
else
  _lats = subwrd(ly,6)
  _late = subwrd(ly,6)
  _ys = subwrd(ly,9)
  _ye = subwrd(ly,9)
endif
if ( subwrd(lz,7) = 'to')
  _levs = subwrd(lz,6)
  _leve = subwrd(lz,8)
  _zs = subwrd(lz,11)
  _ze = subwrd(lz,13)
else
  _levs = subwrd(lz,6)
  _leve = subwrd(lz,6)
  _zs = subwrd(lz,9)
  _ze = subwrd(lz,9)
endif
if ( subwrd(lt,7) = 'to')
  _tims = subwrd(lt,6)
  _time = subwrd(lt,8)
  _ts = subwrd(lt,11)
  _te = subwrd(lt,13)
else
  _tims = subwrd(lt,6)
  _time = subwrd(lt,6)
  _ts = subwrd(lt,9)
  _te = subwrd(lt,9)
endif
return
******************************************************
*****************************************************
