author1="Lifeng Luo, Jared Entin and Alan Robock"
author2="Department of Environmental Sciences"
author3="Rutgers University"
title="Total runoff (mm/day)"
note1="Red:          soil moisture < 200 mm "
note2="Blue:  200 mm < soil moisture < 280 mm "
note3="Green: 280 mm < soil moisture        "
'set display color white'
'c'
timestart=01JAN66
timeend=31DEC83
'set time 'timestart' 'timeend
*'run 'running.gs' 'pcp' '4' '1' 'pcp
*'run 'running.gs' 'dch' '2' '1' 'dch

i=7
while(i<8)
xpos=1
ypos=7.75
'c'
'set gxout scatter'
'set grads off'
linenum=6+(i-1)*24
lineend=6+i*24
*while(linenum<lineend)
*' q file 1'
*answer=sublin(result,linenum)
*first=subwrd(answer,1)
*if (substr(first,1,3)=pcp)
*vari1=subwrd(answer,1)
*endif
*if (substr(first,1,3)=sfr)
*vari2=subwrd(answer,1)
*endif
*linenum=linenum+1
*endwhile

*'run 'running.gs' 'vari1' '1' '3''pcp
*'run 'running.gs' 'vari2' '1' '3' 'sfr
*'run 'dfnlag.gs' 'pcp' 'sfr 

'run 'modelnumber.gs' 'i
model=result
'run 'modelnameup.gs' 'model
figtit=result
'set ccolor 2'
'run 'colume.gs' 'model' 'timestart' 'timeend' 'xpos' 'ypos' 'sfr' '1' 'dch' '2' -4 '28 
'draw title Total runoff (mm/day) '
*'set ccolor 2'
*'run 'colume.gs' 'model' 'timestart' 'timeend' 'xpos' 'ypos' 'trf' '6' 'dch' '2' -4 '28  
*'draw title Total runoff (mm/day) '
*'set ccolor 4'
*'run 'colume.gs' 'model' 'timestart' 'timeend' '%(xpos+5)%' 'ypos' 'trf' '7' 'dch' '2' -4 '28  
*'draw title Total runoff (mm/day) '              
*'set ccolor 3'
*'run 'colume.gs' 'model' 'timestart' 'timeend' 'xpos' '%(ypos-4)%' 'trf' '8' 'dch' '2' -4 '28  
*'draw title Total runoff (mm/day) '              

'set ccolor 3'
'run 'colume.gs' 'model' 'timestart' 'timeend' '%(xpos+5)%' 'ypos' 'swe' '1' 'snw' '4' -40 '260
'draw title SWE (mm) '               
'set ccolor 4'
'run 'colume.gs' 'model' 'timestart' 'timeend' 'xpos%' '%(ypos-4)%' 'slm' '1' 'slm' '3' '100' '360
'draw title Soil moisture (mm) '               

'set string 1 bl 5'
'set strsiz 0.12 0.12'
'draw string '6' '1.7' 'author1
'draw string '6' '1.5' 'author2
'draw string '6' '1.3' 'author3
*'set string 1 bl 6'
*'set strsiz 0.25 0.25'
*'draw string '5.9' '2.9' 'title
*'set strsiz 0.12 0.12'
*'set string 2 bl 5'
*'draw string '6' '2.5' 'note1
*'set string 4 bl 5'
*'draw string '6' '2.3' 'note2
*'set string 3 bl 5'
*'draw string '6' '2.1' 'note3
'set string 1 bl 6'
'set strsiz 0.3 0.3'
'draw string '7.5' '3.25' 'figtit
'wi 'model'_'trf3cats'.'gif
'enable print 'model'-'trf3cats'.'gmf
'print'
'disable print'
i=i+1
'set parea off'
'set vpage off'
endwhile
