#
# This scripts plot the stream network over a basin using a flowdirection file
#
#

function stream(args)
filename=subwrd(args,1)
systemopt=subwrd(args,2)
if(substr(systemopt,1,1) != '-')
streamcolor=subwrd(args,2)
outletcolor=subwrd(args,3)
thick = subwrd(args,4)
systemopt='-uw'
else
streamcolor=subwrd(args,3)
outletcolor=subwrd(args,4)
thick = subwrd(args,5)
endif

if(filename = "")
say "Usage: streamnetwork flow_dir_file streamcolor outletcolor"
return
endif

if(streamcolor = "")
streamcolor=4
endif

if(outletcolor = "")
outletcolor=streamcolor
endif

i=1
while(i<=6)
ret=read(filename)
code = sublin(ret,1)
if(code != 0)
say 'read file 'file' error wite code # 'code
stop=1
endif

data = sublin(ret,2)

if(subwrd(data,1) = 'ncols')
ncols=subwrd(data,2)
endif
if(subwrd(data,1) = 'nrows')
nrows=subwrd(data,2)
endif
if(subwrd(data,1) = 'xllcorner')
xll=subwrd(data,2)
endif
if(subwrd(data,1) = 'yllcorner')
yll=subwrd(data,2)
endif
if(subwrd(data,1) = 'cellsize')
reso=subwrd(data,2)
endif
if(subwrd(data,1) = 'NODATA_value')
missing=subwrd(data,2)
endif
i=i+1
endwhile

res2 = reso/2
xcl = xll
ycr = yll+(nrows*reso)

counter=0

'q gxinfo'
xdata=sublin(result,3)
xmin = subwrd(xdata,4)
xmax = subwrd(xdata,6)
ydata = sublin(result,4)
ymin = subwrd(ydata,4)
ymax = subwrd(ydata,6)

stop=0
row=1
while(row<=nrows & stop=0)
ret=read(filename)
code = sublin(ret,1)
if(code != 0)
say 'read file error wite code # 'code
say 'stop at row 'row
stop=1
endif

data = sublin(ret,2)
col=1
while(col<=ncols)
val=subwrd(data,col)
if(val != missing)
startx=xcl+col*reso-res2
starty=ycr-row*reso+res2

counter=counter+1

*outlet
if(val = 9 | val = -9)
'q w2xy 'startx' 'starty
sx = subwrd(result,3)
sy = subwrd(result,6)
'set line 'outletcolor' 1 'thick
'draw mark 5 'sx' 'sy' 0.1'
endif

if(systemopt = '-uw')
endx=flowx(startx,val,reso)
endy=flowy(starty,val,reso)
endif

if(systemopt = '-dag')
endx=flowx2(startx,val,reso)
endy=flowy2(starty,val,reso)
endif

*say startx'  'starty' 'endx' 'endy' 'val
'q w2xy 'startx' 'starty
sx = subwrd(result,3)
sy = subwrd(result,6)

'q w2xy 'endx' 'endy
ex = subwrd(result,3)
ey = subwrd(result,6)

if(sx>xmin & sx<xmax & sy< ymax & sy>ymin & ex>xmin & ex<xmax & ey< ymax & ey>ymin)
'set line 'streamcolor' 1 'thick
'draw line 'sx' 'sy' 'ex' 'ey' '
endif
endif
col=col+1
endwhile

row=row+1
endwhile

return(counter)

***********functions*****************************

function flowx(startx,val,reso)
endx=startx
if(val=2 | val=3 | val=4)
endx=startx+reso
endif
if(val=6 | val=7 | val=8)
endx=startx-reso
endif
return(endx)

function flowy(starty,val,reso)
endy=starty
if(val=8 | val=1 | val=2)
endy=starty+reso
endif
if(val=4 | val=5 | val=6)
endy=starty-reso
endif
return(endy)

function flowx2(startx,val,reso)
endx=startx
if(val=128 | val=1 | val=2)
endx=startx+reso
endif
if(val=8 | val=16 | val=32)
endx=startx-reso
endif
return(endx)

function flowy2(starty,val,reso)
endy=starty
if(val=32 | val=64 | val=128)
endy=starty+reso
endif
if(val=2 | val=4 | val=8)
endy=starty-reso
endif
return(endy)
