* calculates explained variance of VARIMAX pattern
*
*
* USAGE: run varimax dired filecut [numeofs]
*
*    dired: directory containing the eof-files
*    filecut: base name of eof files (eof.[filecut]_eof.ctl)
*    filecut: base name of eof files (eof.[filecut]_vari.ctl)
*    numeofs: default is 10
*
*    writes file: [dired]/eof.[filecut].vari_eval.txt
*
*
*	NOTE: the calculation of the explained variance is not exact
*	      but it is near to the real explained variance
*	      this program is build for the output of the programs
*             COSTOM MADE SOFTWARE/GRADS/eof.gs
*             COSTOM MADE SOFTWARE/GRADS/varimax.f
*
*
*
*	AUTHOR: Dietmar Dommenget
*
function variance(arg)
*
*
*dired='/scr/daten/montecarlo'
*filecut='MC.trop.atl.pattern'
dired=subwrd(arg,1)
filecut=subwrd(arg,2)
numeof=subwrd(arg,3)
if(filecut='')
  say ''
  say ''
  say '  USAGE: run varimax dired filecut [numeofs]'
  say ''
  say '      dired: directory containing the eof-files'
  say '    filecut: base name of eof files (eof.[filecut]_eof.ctl)'
  say '    filecut: base name of eof files (eof.[filecut]_vari.ctl)'
  say '    numeofs: default is 10'
  say ''
  say '    writes file: [dired]/eof.[filecut].vari_eval.txt'
  say ''
  say '	NOTE: the calculation of the explained variance is not exact'
  say '	      but it is near to the real explained variance'
  say '	      this program is build for the output of the programs'
  say '             COSTOM MADE SOFTWARE/GRADS/eof.gs'
  say '             COSTOM MADE SOFTWARE/GRADS/varimax.f'
  say ''
  return
endif
if(numeof='');numeof=10;endif
outfile='eof.'filecut'.vari_eval.txt'
'reinit'
'open 'dired'/eof.'filecut'_vari.ctl'
*
*
*
gxstate()
*
* sum of exp. vari in % for eofs
*
vari='var1'
evalf=dired'/eof.'filecut'_eval.txt'
ok=read(evalf)
procent=0.0
neof=1
while(neof<=numeof)
  ok=read(evalf)
  ook=sublin(ok,2)
  ookk=subwrd(ook,3)
*  say 'exp. pro. = 'ookk
  procent=procent+ookk
  neof=neof+1
endwhile
procent=procent/100.0
say 'procent='procent
*
* sum of exp. vari for varimax
*
'define exvari=0.0'
neof=1
while(neof<=numeof)
  'set t 'neof
  'define exvari=exvari+aave('vari'*'vari',x='_xs',x='_xe',y='_ys',y='_ye')'
  neof=neof+1
endwhile
'd exvari'
sumvar=subwrd(result,4)
say 'exvari='sumvar
*
* calc exp. vari.
*
neof=1
while(neof<=numeof)
  'set t 'neof
  'define vari=aave('vari'*'vari',x='_xs',x='_xe',y='_ys',y='_ye')'
   'd vari'
   dum=subwrd(result,4)
   xvar=100*procent*dum/sumvar
  say 'exp. variance = 'xvar' %'
  dum=write(dired'/'outfile,neof',  'xvar',  'xvar)
  neof=neof+1
endwhile
return


******************************************************
******************************************************
function gxstate()
*
*  Get dimension information as global var _xs,_xe,...
*
'query dim'
dinf = result
lx = sublin(dinf,2)
ly = sublin(dinf,3)
lz = sublin(dinf,4)
lt = sublin(dinf,5)
if ( subwrd(lx,7) = 'to')
  _lons = subwrd(lx,6)
  _lone = subwrd(lx,8)
  _xs = subwrd(lx,11)
  _xe = subwrd(lx,13)
else
  _lons = subwrd(lx,6)
  _lone = subwrd(lx,6)
  _xs = subwrd(lx,9)
  _xe = subwrd(lx,9)
endif
if ( subwrd(ly,7) = 'to')
  _lats = subwrd(ly,6)
  _late = subwrd(ly,8)
  _ys = subwrd(ly,11)
  _ye = subwrd(ly,13)
else
  _lats = subwrd(ly,6)
  _late = subwrd(ly,6)
  _ys = subwrd(ly,9)
  _ye = subwrd(ly,9)
endif
if ( subwrd(lz,7) = 'to')
  _levs = subwrd(lz,6)
  _leve = subwrd(lz,8)
  _zs = subwrd(lz,11)
  _ze = subwrd(lz,13)
else
  _levs = subwrd(lz,6)
  _leve = subwrd(lz,6)
  _zs = subwrd(lz,9)
  _ze = subwrd(lz,9)
endif
if ( subwrd(lt,7) = 'to')
  _tims = subwrd(lt,6)
  _time = subwrd(lt,8)
  _ts = subwrd(lt,11)
  _te = subwrd(lt,13)
else
  _tims = subwrd(lt,6)
  _time = subwrd(lt,6)
  _ts = subwrd(lt,9)
  _te = subwrd(lt,9)
endif
return
******************************************************


