*    Writes data to a grads file pair. 
*
function writef (arg)
*
*
* DISCRIPTION:
*    Writes data expression to file and makes a 
*    control file for it.
* USAGE: 
*   run writef <data-expr> <filename> [<abbrev> dt cx cy]
*
*   with
*            <data-expr>:   grads data expression
*        <file basename>:   output file basename.
*               <abbrev>:   variable name for the data 
*                           (defaults to the first 3 char. 
*                            of <data-expression>)
*                    dt :   time increment (default: 1mo)
*                    cx :   indicate that lon is linear
*                    cy :   indicate that lat is linear
*
* EXAMPLE:
*    ga->run writef ave(tmp,x=1,x=10) avetmp
*
*       writes data to file "avetmp.gad" with control file 
*       "avetmp.ctl" the data abbreviation defaults to  
*       "ave", the time increment to "1mo".
*     
* 
*   Written by M. Muennich 9/95 (edited by dietmar dommenget)
*
*
*
*
data=subwrd(arg,1)
file=subwrd(arg,2)
varn=subwrd(arg,3)
dtim=subwrd(arg,4)
cxx=subwrd(arg,5)
cyy=subwrd(arg,6)
if( file = '' )
say '    Writes data to a grads file pair. '
say ' DISCRIPTION:'
say '    Writes data expression to file and makes a '
say '    control file for it.'
say ' USAGE: '
say '   run writef <data-expr> <filename> [<abbrev> dt cx cy]'
say ''
say '   with'
say '            <data-expr>:   grads data expression'
say '        <file basename>:   output file basename.'
say '               <abbrev>:   variable name for the data '
say '                           (defaults to the first 3 char. '
say '                            of <data-expression>)'
say '                    dt :   time increment (default: 1mo)'
say '                   cx :   indicate that lon is linear'
say '                   cy :   indicate that lat is linear'
say ''
say ' EXAMPLE:'
say '    ga->run writef ave(tmp,x=1,x=10) avetmp'
say ''
say '       writes data to file "avetmp.gad" with control file '
say '       "avetmp.ctl" the data abbreviation defaults to  '
say '       "ave", the time increment to "1mo".'
say '     '
return
endif
cx=false
cy=false
if (cxx = 'cx' )
  cx=true
endif
if (cxx = 'cy' )
  cy=true
endif
if (cyy = 'cx' )
  cx=true
endif
if (cyy = 'cy' )
  cy=true
endif
say 'varn = 'varn
if(varn ='' )
say 'data = 'data
   varn=substr(data,1,3)
endif
*        save graphic state
*  Somehow this does not work so I always do a "set gxout shaded"
*lstgx=lastgx()
*say ' lastgx = ' lstgx
*        write data file
'set gxout fwrite'
'set fwrite ' file'.gad'
'd const('data',9.e27,-u)'
*'d 'data
'disable fwrite'
*        reset graphic state
*'set gxout ' lstgx      // too bad it doesn't work!
say 'NOTE: gxout reset to contour'
'set gxout contour'
*        write control file
wrctl(data,file,dtim,varn,cx,cy)
return
 
******************************************************
function lastgx(data,file,varn)
*
*  Get last gxout
*
'query gxinfo'
lstgx=subwrd(result,4)
return lstgx
******************************************************

function wrctl(data,file,dtim,varn,cx,cy)
*
* write control file
*
ctlfile=file'.ctl'
line='dset ^'file'.gad'
ok=write(ctlfile,line)
say 'Info line in ctl -file = ?'
pull info
line='title 'info
ok=write(ctlfile,line,append)
line='undef 9.e27'
ok=write(ctlfile,line,append)
line='options cray_32bit_ieee big_endian'
ok=write(ctlfile,line,append)
nz=wrdims(ctlfile,dtim,cx,cy)
ok=write(ctlfile,'vars 1',append)
line=varn' 'nz' 0 data 1'
ok=write(ctlfile,line,append)
ok=write(ctlfile,'endvars',append)
return

******************************************************


******************************************************
function wrdims(ctlfile,dtim,cx,cy)
*
*  write current dimensions to ctlfile
*
'query dims'
dinf = result
lx = sublin(dinf,2)
ly = sublin(dinf,3)
lz = sublin(dinf,4)
lt = sublin(dinf,5)

* write x dims:
if ( subwrd(lx,3) = 'varying')
 if (cx = 'false' )
  xs = subwrd(lx,11)
  xe = subwrd(lx,13)
  nx = xe-xs+1
  lons = subwrd(lx,6)
  lone = subwrd(lx,8)
  line='xdef 'nx' levels '
  ok=write(ctlfile,line,append)
  xx=xs+1
  xw=10
  lonx=lons
  while (xx < xe)
      'set x 'xx
     'query dims'
      dinfx=result
      llx= sublin(dinfx,2)
      lonx=lonx' 'subwrd(llx,6)
      if (xx = xw)
         ok=write(ctlfile,lonx,append)
         lonx=''
         xw=xw+10
      endif
      xx=xx+1
  endwhile
  lonx=lonx' 'lone
  ok=write(ctlfile,lonx,append)
  'set x 'xs' 'xe
 else
  xs = subwrd(lx,11)
  xe = subwrd(lx,13)
  nx = xe-xs+1
  lons = subwrd(lx,6)
  lone = subwrd(lx,8)
  dlon = (lone-lons)/(xe-xs)
  line='xdef 'nx' linear 'lons' 'dlon
  ok=write(ctlfile,line,append)
 endif
else
  lons = subwrd(lx,6)
  line='xdef 1 linear 'lons' 1'
  ok=write(ctlfile,line,append)
endif

* write y dims:
if ( subwrd(ly,3) = 'varying')
 if (cy = false)
  ys = subwrd(ly,11)
  ye = subwrd(ly,13)
  ny = ye-ys+1
  lats = subwrd(ly,6)
  late = subwrd(ly,8)
  line='ydef 'ny' levels '
  ok=write(ctlfile,line,append)
  yy=ys+1
  yw=10
  laty=lats
  while (yy < ye)
      'set y 'yy
     'query dims'
      dinfy=result
      lly= sublin(dinfy,3)
      laty=laty' 'subwrd(lly,6)
      if (yy = yw)
         ok=write(ctlfile,laty,append)
         laty=''
         yw=yw+10
      endif
      yy=yy+1
  endwhile
  laty=laty' 'late
  ok=write(ctlfile,laty,append)
  'set y 'ys' 'ye
 else
  ys = subwrd(ly,11)
  ye = subwrd(ly,13)
  ny = ye-ys+1
  lats = subwrd(ly,6)
  late = subwrd(ly,8)
  dlat = (late-lats)/(ye-ys)
  line='ydef 'ny' linear 'lats' 'dlat
  ok=write(ctlfile,line,append)
 endif
else
  lats = subwrd(ly,6)
  line='ydef 1 linear 'lats' 1'
  ok=write(ctlfile,line,append)
endif

* write z dims:
if ( subwrd(lz,3) = 'varying')
  zs = subwrd(lz,11)
  ze = subwrd(lz,13)
  nz = ze-zs+1
  lats = subwrd(lz,6)
  late = subwrd(lz,8)
  dlat = (late-lats)/(ze-zs)
  line='zdef 'nz' linear 'lats' 'dlat
  ok=write(ctlfile,line,append)
else
  nz = 1
  lats = subwrd(lz,6)
  line='zdef 1 linear 'lats' 1'
  ok=write(ctlfile,line,append)
endif

* time dims:
if ( subwrd(lt,3) = 'varying')
  ts = subwrd(lt,11)
  te = subwrd(lt,13)
  nt = te-ts+1
  say 'lt = 'lt
  tims = subwrd(lt,6)
  say ' tims = 'tims
  if (dtim = '')
     say ' Time step = ? (e.g. 1mo or 1yr)'
     pull dtim
     if (dtim = '')
        dtim = 1mo
     endif
  endif
  line='tdef 'nt' linear 'tims' 'dtim
  ok=write(ctlfile,line,append)
else
  tims = subwrd(lt,6)
  line='tdef 1 linear 'tims' 1mo'
  ok=write(ctlfile,line,append)
endif
return nz
